/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.disklrucache.impl;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.net.disklrucache.DiskLruCache;
import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.hisavana.net.disklrucache.impl.IDiskCache;
import com.cloud.hisavana.net.disklrucache.utils.DiskLruCacheUtil;
import com.cloud.hisavana.net.disklrucache.utils.SafeKeyUtils;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.cloud.sdk.commonutil.util.MD5;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Response;

public class DiskCacheImpl
implements IDiskCache {
    private static final String TAG = "DiskCacheImpl";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private DiskLruCache diskLruCache;
    private File directory;
    private final long maxSize;
    private int cacheMode;

    protected DiskCacheImpl(File directory, long maxSize, int cacheMode) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.cacheMode = cacheMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DiskLruCache getDiskLruCache() throws IOException {
        DiskLruCache localDiskLruCache = this.diskLruCache;
        if (localDiskLruCache != null) return localDiskLruCache;
        Class<DiskCacheImpl> clazz = DiskCacheImpl.class;
        synchronized (DiskCacheImpl.class) {
            localDiskLruCache = this.diskLruCache;
            if (localDiskLruCache != null) return localDiskLruCache;
            File cacheFile = DiskLruCacheUtil.getCacheDirectory(this.cacheMode);
            if (Log.isLoggable((String)"ADSDK", (int)3)) {
                CommonLogUtil.netLog((String)(" ----- getDiskLruCache: directory = " + this.directory + " , cacheFile = " + cacheFile));
            }
            this.directory = this.directory == null ? cacheFile : this.directory;
            this.diskLruCache = DiskLruCache.open(this.directory, 1, 1, this.maxSize);
            return this.diskLruCache;
        }
    }

    @Override
    public File get(ImageCacheURL key) {
        return this.getImageFile(key);
    }

    @Override
    public File get(String key) {
        return this.getFile(key);
    }

    protected File getImageFile(ImageCacheURL imageURL) {
        if (TextUtils.isEmpty((CharSequence)imageURL.getOriginUrl())) {
            return null;
        }
        File directory = DiskLruCacheUtil.getCacheDirectory(this.cacheMode);
        if (directory == null) {
            return null;
        }
        String fileName = SafeKeyUtils.getSafeKey(imageURL) + ".0";
        try {
            this.getDiskLruCache().get(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(directory + File.separator + fileName);
    }

    protected File getFile(String fileName) {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        File directory = DiskLruCacheUtil.getCacheDirectory(this.cacheMode);
        if (directory == null) {
            return null;
        }
        String key = MD5.MD5Encode((String)fileName) + ".0";
        try {
            this.getDiskLruCache().get(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(directory + File.separator + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(ImageCacheURL key, byte[] buf) {
        String filePath = "";
        OutputStream outputStream = null;
        String safeKey = SafeKeyUtils.getSafeKey(key);
        try {
            DiskLruCache.Snapshot currentValue = this.getDiskLruCache().get(safeKey);
            if (currentValue != null) {
                String string = null;
                return string;
            }
            DiskLruCache.Editor editor = this.diskLruCache.edit(safeKey);
            if (editor == null) {
                throw new IllegalStateException("Had two simultaneous puts for: " + safeKey);
            }
            try {
                outputStream = editor.newOutputStream(0);
                outputStream.write(buf);
                outputStream.flush();
                editor.commit();
                this.diskLruCache.flush();
                filePath = DiskLruCacheUtil.getCacheFilePath(key.getOriginUrl(), this.cacheMode);
                if (Log.isLoggable((String)"ADSDK", (int)3)) {
                    CommonLogUtil.netLog((String)("url :" + key.getOriginUrl() + " cacheToDisk with buff: " + filePath));
                }
            }
            finally {
                editor.abortUnlessCommitted();
            }
            DiskLruCacheUtil.closeQuietly(outputStream);
        }
        catch (IOException e) {
            CommonLogUtil.netLog((String)("put: fail" + filePath));
        }
        finally {
            DiskLruCacheUtil.closeQuietly(outputStream);
        }
        return filePath;
    }

    @Override
    public String put(ImageCacheURL key, Response response) {
        if (response != null && response.body() != null) {
            return this.put(key, response.body().byteStream());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String put(ImageCacheURL key, InputStream inputStream) {
        if (key == null) return "";
        if (inputStream == null) {
            return "";
        }
        String filePath = "";
        OutputStream outputStream = null;
        String safeKey = SafeKeyUtils.getSafeKey(key);
        try {
            DiskLruCache.Snapshot currentValue2332 = this.getDiskLruCache().get(safeKey);
            if (currentValue2332 != null) {
                String string = null;
                return string;
            }
            DiskLruCache.Editor editor = this.diskLruCache.edit(safeKey);
            if (editor == null) {
                throw new IllegalStateException("Had two simultaneous puts for: " + safeKey);
            }
            try {
                int bytesRead;
                outputStream = editor.newOutputStream(0);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.flush();
                editor.commit();
                this.diskLruCache.flush();
                filePath = DiskLruCacheUtil.getCacheFilePath(key.getOriginUrl(), this.cacheMode);
                if (Log.isLoggable((String)"ADSDK", (int)3)) {
                    CommonLogUtil.netLog((String)("url :" + key.getOriginUrl() + " cacheToDisk with response: " + filePath));
                }
            }
            finally {
                editor.abortUnlessCommitted();
            }
            DiskLruCacheUtil.closeQuietly(outputStream);
        }
        catch (Exception e) {
            CommonLogUtil.netLog((String)("put: fail" + filePath));
            return filePath;
        }
        try {
            inputStream.close();
            return filePath;
        }
        catch (IOException currentValue2332) {
            return filePath;
        }
        finally {
            DiskLruCacheUtil.closeQuietly(outputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void delete(ImageCacheURL key) {
        String safeKey = SafeKeyUtils.getSafeKey(key);
        try {
            this.getDiskLruCache().remove(safeKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        try {
            this.getDiskLruCache().delete();
            this.resetDiskCache();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @Override
    public boolean isFileExit(String url) {
        ImageCacheURL imageCacheURL = new ImageCacheURL(url);
        String safeKey = SafeKeyUtils.getSafeKey(imageCacheURL);
        try {
            DiskLruCache.Snapshot currentValue = this.getDiskLruCache().get(safeKey);
            return currentValue != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }
}

