/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import com.cloud.hisavana.protocol.okhttptransport.RedirectStrategy;
import com.cloud.hisavana.protocol.okhttptransport.RequestBodyConverterImpl;
import com.cloud.hisavana.protocol.okhttptransport.RequestResponseConverter;
import com.cloud.hisavana.protocol.okhttptransport.ResponseConverter;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executors;
import org.chromium.net.CronetEngine;

abstract class RequestResponseConverterBasedBuilder<SubBuilderT extends RequestResponseConverterBasedBuilder<?, ? extends ObjectBeingBuiltT>, ObjectBeingBuiltT> {
    private static final int DEFAULT_THREAD_POOL_SIZE = 4;
    private final CronetEngine cronetEngine;
    private int uploadDataProviderExecutorSize = 4;
    private RedirectStrategy redirectStrategy = null;
    private final SubBuilderT castedThis;

    RequestResponseConverterBasedBuilder(CronetEngine cronetEngine, Class<SubBuilderT> clazz) {
        this.cronetEngine = (CronetEngine)Preconditions.checkNotNull((Object)cronetEngine);
        Preconditions.checkArgument((boolean)this.getClass().equals(clazz));
        this.castedThis = this;
    }

    public final SubBuilderT setUploadDataProviderExecutorSize(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"The number of threads must be positive!");
        this.uploadDataProviderExecutorSize = size;
        return this.castedThis;
    }

    public final SubBuilderT setRedirectStrategy(RedirectStrategy redirectStrategy) {
        Preconditions.checkNotNull((Object)redirectStrategy);
        this.redirectStrategy = redirectStrategy;
        return this.castedThis;
    }

    abstract ObjectBeingBuiltT build(RequestResponseConverter var1);

    public final ObjectBeingBuiltT build() {
        if (this.redirectStrategy == null) {
            this.redirectStrategy = RedirectStrategy.defaultStrategy();
        }
        RequestResponseConverter converter = new RequestResponseConverter(this.cronetEngine, Executors.newFixedThreadPool(this.uploadDataProviderExecutorSize), RequestBodyConverterImpl.create(Executors.newCachedThreadPool()), new ResponseConverter(), this.redirectStrategy);
        return this.build(converter);
    }
}

