package com.cloud.hisavana.net

import com.cloud.hisavana.net.disklrucache.listener.LruCleanCallBack
import com.cloud.hisavana.net.impl.IHttpCallback
import com.cloud.hisavana.net.utils.CommonWorkThread
import com.cloud.sdk.commonutil.util.CommonLogUtil
import java.util.concurrent.CopyOnWriteArrayList

/**
 * 所有的请求接口
 *
 * @author chenshijun
 */
object HttpRequest {
    const val ONLINE_MODE = 1 //在线模式缓存池
    const val OFFLINE_MODE = 2 //离线模式缓存池
    const val VIDEO_MODE = 3 //视频缓存池
    const val DEFAULT_MODE = 4 //内置广告缓存池

    /** LRU清理的监听 */
    val lruCleanCallBacks: CopyOnWriteArrayList<LruCleanCallBack> =
        CopyOnWriteArrayList<LruCleanCallBack>()

    /** 在线广告的缓存大小 */
    var cacheSize = 0

    /** 离线广告的缓存大小 */
    var offlineCacheSize = 0

    var videoCacheSize = 0
    var defaultCacheSize = 0

    /**
     * GET请求
     *
     * @param url      URL请求地址
     * @param params   入参
     * @param callback 回调接口
     */
    fun getRequest(url: String?, params: RequestParams?, callback: IHttpCallback?) {
        try {
            var tempParams: RequestParams? = params
            if (tempParams == null) {
                tempParams = RequestParams()
            }
            tempParams.putHeads("isDownload", "false")
            val request = CommonRequest.createGetRequest(url, tempParams, callback)
            if (request != null) {
                CommonOkHttpClient.get(request, callback)
            } else {
                CommonLogUtil.netLog("getRequest:  create request is null")
            }
        } catch (e : Exception) {
            CommonLogUtil.netLog("postRequest:  post request is error")
        }

    }

    @JvmStatic
    fun postRequest(
        url: String?,
        params: RequestParams?,
        callback: IHttpCallback?
    ) {
        try {
            var tempParams: RequestParams? = params
            if (tempParams == null) {
                tempParams = RequestParams()
            }
            tempParams.putHeads("isDownload", "false")
            val request = CommonRequest.createPostRequest(url, tempParams, callback)
            if (request != null) {
                CommonOkHttpClient.post(request, callback)
            } else {
                CommonLogUtil.netLog("postRequest:  create request is null")
            }
        } catch (e: Exception) {
            CommonLogUtil.netLog("postRequest:  post request is error")
        }

    }

    /**
     * 下载图片
     *
     * @param url 下载地址
     * @param params   入参
     * @param callback 回调接口
     */
    @JvmStatic
    fun downloadImage(
        url: String?,
        params: RequestParams?,
        callback: IHttpCallback?
    ) {
        try {
            var tempParams: RequestParams? = params
            if (tempParams == null) {
                tempParams = RequestParams()
            }
            tempParams.putHeads("isDownload", "true")

            val request = CommonRequest.createGetRequest(url, tempParams, callback)
            if (request != null) {
                CommonWorkThread.getInstance().post {
                    CommonOkHttpClient.downLoadImg(tempParams, request, callback)
                }
            } else {
                CommonLogUtil.netLog("getRequest:  create request is null")
            }
        } catch (e : Exception) {
            CommonLogUtil.netLog("downloadImage:  post request is error")
        }
    }

    /**
     * 添加LRU清理的监听
     */
    fun addLruCleanCallBack(lruCleanCallBack: LruCleanCallBack?) {
        if (lruCleanCallBack == null) {
            return
        }
        lruCleanCallBacks.add(lruCleanCallBack)
    }

    /**
     * 删除LRU清理的监听
     */
    fun clearLruCleanCallBack(lruCleanCallBack: LruCleanCallBack?) {
        if (lruCleanCallBack == null || lruCleanCallBacks.isEmpty()) {
            return
        }
        lruCleanCallBacks.remove(lruCleanCallBack)
    }
}