package com.cloud.hisavana.net.impl;

import okhttp3.Headers;

/**
 * 网路请求的回调
 *
 * @author chenshijun
 */
public interface IHttpCallback {
    void sendResponseMessage(int code, byte[] responseBody);

    void sendResponseMessage(int code, byte[] responseBody, String filePath);

    void sendResponseMessage(int code, byte[] responseBody, Headers responseHeaders);

    void sendStartMessage();

    void sendFinishMessage();

    void sendPauseMessage();

    boolean getUseSyncMode();

    void setUseSyncMode(boolean useSyncMode);

    boolean getUsePoolThread();

    void setUsePoolThread(boolean usePoolThread);

    void sendSuccessMessage(int statusCode, byte[] responseBody);

    void sendSuccessMessage(int statusCode, byte[] responseBody, String filePath);

    void sendSuccessMessage(int statusCode, byte[] responseBody, Headers responseHeaders);

    void sendFailureMessage(int statusCode, byte[] responseBody, Throwable error);

    void sendFailureMessage(int statusCode, byte[] responseBody, Throwable error, Headers responseHeaders);
}
