package com.cloud.hisavana.protocol.intercept

import com.transsin.networkmonitor.MonitorHelper
import okhttp3.Interceptor
import okhttp3.Response

/**
 * 域名的AB拦截器，用于新老域名的替换。
 */
class DomainIntercept(
    private val domainABMap: Map<String, String>
) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        val originRequest = chain.request()
        val url = originRequest.url()
        val newHost = domainABMap[originRequest.url().host()]
        val request = if (newHost != null) {
            originRequest.newBuilder()
                .url(url.newBuilder().host(newHost).build())
                .build().apply {
                    MonitorHelper.updateRequest(chain, this)
                }
        } else {
            originRequest
        }
        return chain.proceed(request)
    }
}