/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.intercept;

import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsin.networkmonitor.MonitorHelper;
import java.net.UnknownHostException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/cloud/hisavana/protocol/intercept/DomainRetryIntercept;", "Lokhttp3/Interceptor;", "hostMap", "", "", "<init>", "(Ljava/util/Map;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "adnetwork_release"})
public final class DomainRetryIntercept
implements Interceptor {
    @NotNull
    private final Map<String, String> hostMap;

    public DomainRetryIntercept(@NotNull Map<String, String> hostMap) {
        Intrinsics.checkNotNullParameter(hostMap, (String)"hostMap");
        this.hostMap = hostMap;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        try {
            Response response = chain.proceed(chain.request());
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"proceed(...)");
            return response;
        }
        catch (Exception e) {
            HttpUrl url = chain.request().url();
            String host = url.host();
            String downHost = this.hostMap.get(host);
            if (downHost != null && e instanceof UnknownHostException) {
                Request request;
                Request $this$intercept_u24lambda_u240 = request = chain.request().newBuilder().url(url.newBuilder().host(downHost).build()).build();
                boolean bl = false;
                CommonLogUtil.netLog((String)("request downgrade, domain failed, failed url is:" + chain.request().url()));
                Intrinsics.checkNotNull((Object)$this$intercept_u24lambda_u240);
                MonitorHelper.INSTANCE.downgrade(chain, $this$intercept_u24lambda_u240, 1005);
                Request buildRequest = request;
                Response response = chain.proceed(buildRequest);
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"proceed(...)");
                return response;
            }
            throw e;
        }
    }
}

