/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.utils;

import android.os.Handler;
import android.os.HandlerThread;

public class CommonWorkThread {
    private static final String WORK_THREAD_NAME = "common_work_thread";
    private final Handler mWorkHandler;

    private CommonWorkThread() {
        HandlerThread workThread = new HandlerThread(WORK_THREAD_NAME);
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
    }

    public void post(Runnable runnable) {
        if (this.mWorkHandler != null) {
            this.mWorkHandler.post(runnable);
        }
    }

    public void postDelay(Runnable runnable, long time) {
        if (this.mWorkHandler != null) {
            this.mWorkHandler.postDelayed(runnable, time);
        }
    }

    public static CommonWorkThread getInstance() {
        return WorkThreadHolder.INSTANCE;
    }

    private static class WorkThreadHolder {
        private static final CommonWorkThread INSTANCE = new CommonWorkThread();

        private WorkThreadHolder() {
        }
    }
}

