package com.cloud.hisavana.net

import java.util.concurrent.ConcurrentHashMap

/**
 * 请求参数
 *
 * @author chenshijun
 */
class RequestParams {
    /** 请求body  */
    var postBody: Any = ""
        set(body) {
            if (body != null) {
                field = body
            }
        }

    /**  线程安全的HashMap  */
    val httpHeaders = ConcurrentHashMap<String, String>()
    val httpParams = ConcurrentHashMap<String, String>()
    /** 是否需要返回物料路径 */
    var isFetchFilePath = false
    /**是否使用cache **/
    var isUseCache = true
    /**是否是下载视频， **/
    var isDownloadVideo = false
    /**
     * 缓存模式，1: 默认缓存（在离线使用）2:离线缓存(弃用) 3:视频缓存（弃用）  4:内置广告的缓存
     */
    var cacheMode = HttpRequest.ONLINE_MODE
    var adCreativeId = "";

    /**
     * 添加get请求时的params参数
     */
    fun putParams(key: String?, value: String?) {
        if (key != null && value != null) {
            httpParams[key] = value
        }
    }

    fun putHeads(key: String?, value: String?) {
        if (key != null && value != null) {
            httpHeaders[key] = value
        }
    }
}