package com.cloud.hisavana.net.utils;


import android.os.Handler;
import android.os.HandlerThread;

/**
 * HandlerThread实现异步加载
 * @author chenshijun
 */
public class CommonWorkThread {
    private static final String WORK_THREAD_NAME = "common_work_thread";

    private final Handler mWorkHandler;

    private CommonWorkThread() {
        HandlerThread workThread = new HandlerThread(WORK_THREAD_NAME);
        workThread.start();
        mWorkHandler = new Handler(workThread.getLooper());
    }

    public void post(Runnable runnable) {
        if (mWorkHandler != null) {
            mWorkHandler.post(runnable);
        }
    }

    public void postDelay(Runnable runnable, long time) {
        if (mWorkHandler != null) {
            mWorkHandler.postDelayed(runnable, time);
        }
    }

    private static class WorkThreadHolder {
        private static final CommonWorkThread INSTANCE = new CommonWorkThread();
    }

    public static CommonWorkThread getInstance() {
        return WorkThreadHolder.INSTANCE;
    }
}
