/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteBufferUtil {
    private static final int BUFFER_SIZE = 16384;
    private static final AtomicReference<byte[]> BUFFER_REF = new AtomicReference();

    private ByteBufferUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer fromFile(File file) throws IOException {
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel channel = null;
        try {
            raf = new RandomAccessFile(file, "r");
            channel = raf.getChannel();
            MappedByteBuffer mappedByteBuffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, 0L, file.length()).load();
            return mappedByteBuffer;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(ByteBuffer buffer, File file) throws IOException {
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel channel = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            channel = raf.getChannel();
            ((FileChannel)channel).write(buffer);
            ((FileChannel)channel).force(false);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void toStream(ByteBuffer byteBuffer, OutputStream os) throws IOException {
        SafeArray safeArray = ByteBufferUtil.getSafeArray(byteBuffer);
        if (safeArray != null) {
            os.write(safeArray.data, safeArray.offset, safeArray.offset + safeArray.limit);
        } else {
            byte[] buffer = BUFFER_REF.getAndSet(null);
            if (buffer == null) {
                buffer = new byte[16384];
            }
            while (byteBuffer.remaining() > 0) {
                int toRead = Math.min(byteBuffer.remaining(), buffer.length);
                byteBuffer.get(buffer, 0, toRead);
                os.write(buffer, 0, toRead);
            }
            BUFFER_REF.set(buffer);
        }
    }

    public static byte[] toBytes(ByteBuffer byteBuffer) {
        byte[] result;
        SafeArray safeArray = ByteBufferUtil.getSafeArray(byteBuffer);
        if (safeArray != null && safeArray.offset == 0 && safeArray.limit == safeArray.data.length) {
            result = byteBuffer.array();
        } else {
            ByteBuffer toCopy = byteBuffer.asReadOnlyBuffer();
            result = new byte[toCopy.limit()];
            toCopy.position(0);
            toCopy.get(result);
        }
        return result;
    }

    public static InputStream toStream(ByteBuffer buffer) {
        return new ByteBufferStream(buffer);
    }

    public static InputStream lengthToStream(InputStream stream, int length) {
        return new ContentLengthInputStream(stream, length);
    }

    public static ByteBuffer fromStream(InputStream stream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(16384);
        byte[] buffer = BUFFER_REF.getAndSet(null);
        if (buffer == null) {
            buffer = new byte[16384];
        }
        int n = -1;
        while ((n = stream.read(buffer)) >= 0) {
            outStream.write(buffer, 0, n);
        }
        BUFFER_REF.set(buffer);
        byte[] bytes = outStream.toByteArray();
        return (ByteBuffer)ByteBuffer.allocateDirect(bytes.length).put(bytes).position(0);
    }

    private static SafeArray getSafeArray(ByteBuffer byteBuffer) {
        if (!byteBuffer.isReadOnly() && byteBuffer.hasArray()) {
            return new SafeArray(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        }
        return null;
    }

    static final class SafeArray {
        private final int offset;
        private final int limit;
        private final byte[] data;

        public SafeArray(byte[] data, int offset, int limit) {
            this.data = data;
            this.offset = offset;
            this.limit = limit;
        }
    }

    private static class ByteBufferStream
    extends InputStream {
        private static final int UNSET = -1;
        private final ByteBuffer byteBuffer;
        private int markPos = -1;

        public ByteBufferStream(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        @Override
        public int available() throws IOException {
            return this.byteBuffer.remaining();
        }

        @Override
        public int read() throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                return -1;
            }
            return this.byteBuffer.get();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.markPos = this.byteBuffer.position();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                return -1;
            }
            int toRead = Math.min(byteCount, this.available());
            this.byteBuffer.get(buffer, byteOffset, toRead);
            return toRead;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.markPos == -1) {
                throw new IOException("Cannot reset to unset mark position");
            }
            this.byteBuffer.position(this.markPos);
        }

        @Override
        public long skip(long byteCount) throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                return -1L;
            }
            long toSkip = Math.min(byteCount, (long)this.available());
            this.byteBuffer.position((int)((long)this.byteBuffer.position() + toSkip));
            return toSkip;
        }
    }

    public static class ContentLengthInputStream
    extends InputStream {
        private final InputStream stream;
        private final int length;

        public ContentLengthInputStream(InputStream stream, int length) {
            this.stream = stream;
            this.length = length;
        }

        @Override
        public int available() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.stream.read(buffer);
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            return this.stream.read(buffer, byteOffset, byteCount);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long byteCount) throws IOException {
            return this.stream.skip(byteCount);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

