/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.net.utils;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.cloud.sdk.commonutil.util.HSCoreUtil;
import java.io.File;

public final class StorageUtils {
    private static final String NORMAL_CACHE = "hisavana_net_cache";
    private static final String EXO_VIDEO_CACHE = "hisavana_video_cache";
    private static final String NORMAL_VIDEO_CACHE = "hisavana_normal_video_cache";
    private static final String DEFAULT_CACHE = "hisavana_default_cache";
    private static final String TAG = "StorageUtils";
    private static volatile File mAppCacheDir = null;

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    public static File getCacheDirectory(Context context, boolean preferExternal) {
        File appCacheDir = null;
        if (preferExternal && (appCacheDir = StorageUtils.getExternalFileDir(context)) != null && appCacheDir.exists() && !(appCacheDir = new File(appCacheDir.getPath() + File.separator + NORMAL_CACHE)).exists() && !appCacheDir.mkdir()) {
            Log.w((String)TAG, (String)"can't create cache file");
        }
        if (!(appCacheDir != null && (appCacheDir.exists() || appCacheDir.mkdirs()) || (appCacheDir = HSCoreUtil.getExternalCacheDir((Context)context.getApplicationContext())) != null && appCacheDir.exists())) {
            appCacheDir = context.getFilesDir();
        }
        if (appCacheDir == null || !appCacheDir.exists()) {
            appCacheDir = context.getCacheDir();
        }
        if (appCacheDir == null) {
            String cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + NORMAL_CACHE;
            Log.w((String)TAG, (String)("Can't define system cache directory! '%s' will be used." + cacheDirPath));
            appCacheDir = new File(cacheDirPath);
        }
        return appCacheDir;
    }

    public static File getExternalFileDir(Context context) {
        if (mAppCacheDir != null) {
            return mAppCacheDir;
        }
        String filesDir = Environment.getExternalStorageDirectory() + "/Android/data/" + context.getPackageName() + "/files";
        File file = new File(filesDir);
        if (!file.exists()) {
            boolean result = file.mkdir();
            if (result) {
                mAppCacheDir = file;
            } else {
                Log.w((String)TAG, (String)"getExternalFileDir is not exists");
            }
        } else {
            mAppCacheDir = file;
        }
        if (mAppCacheDir == null) {
            String externalStorageState;
            try {
                externalStorageState = Environment.getExternalStorageState();
            }
            catch (NullPointerException e) {
                externalStorageState = "";
            }
            catch (IncompatibleClassChangeError e) {
                externalStorageState = "";
            }
            if ("mounted".equals(externalStorageState)) {
                mAppCacheDir = context.getExternalFilesDir(null);
            }
        }
        return mAppCacheDir;
    }

    public static File getExoCacheDirectory(Context context, boolean preferExternal) {
        String cacheDirPath;
        boolean result;
        String path;
        File appCacheDir = null;
        if (preferExternal && (appCacheDir = StorageUtils.getExternalFileDir(context)) != null && !(appCacheDir = new File(path = appCacheDir.getPath() + File.separator + EXO_VIDEO_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getExoCacheDirectory,storage cache is not ready");
        }
        if (appCacheDir == null && !(appCacheDir = new File(cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + EXO_VIDEO_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getExoCacheDirectory,app cache path is not ready");
        }
        return appCacheDir;
    }

    public static File getVideoCacheDirectory(Context context, boolean preferExternal) {
        String cacheDirPath;
        boolean result;
        String path;
        File appCacheDir = null;
        if (preferExternal && (appCacheDir = StorageUtils.getExternalFileDir(context)) != null && !(appCacheDir = new File(path = appCacheDir.getPath() + File.separator + NORMAL_VIDEO_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getVideoCacheDirectory,storage cache is not ready");
        }
        if (appCacheDir == null && !(appCacheDir = new File(cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + NORMAL_VIDEO_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getVideoCacheDirectory,app cache path is not ready");
        }
        return appCacheDir;
    }

    public static File getDefaultCacheDirectory(Context context, boolean preferExternal) {
        String cacheDirPath;
        boolean result;
        String path;
        File appCacheDir = null;
        if (preferExternal && (appCacheDir = StorageUtils.getExternalFileDir(context)) != null && !(appCacheDir = new File(path = appCacheDir.getPath() + File.separator + DEFAULT_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,storage cache is not ready");
        }
        if (appCacheDir == null && !(appCacheDir = new File(cacheDirPath = "/data/data/" + context.getPackageName() + File.separator + DEFAULT_CACHE)).exists() && !(result = appCacheDir.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,app cache path is not ready");
        }
        return appCacheDir;
    }
}

