/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.intercept;

import com.cloud.hisavana.protocol.donwgrade.CronetInterceptListener;
import com.cloud.hisavana.protocol.donwgrade.DownCountHelper;
import com.cloud.hisavana.protocol.donwgrade.DowngradePolicy;
import com.cloud.hisavana.protocol.extension.NetWorkExtKt;
import com.cloud.hisavana.protocol.okhttptransport.CronetInterceptor;
import com.cloud.sdk.commonutil.util.CommonLogUtil;
import com.transsin.networkmonitor.MonitorFactory;
import com.transsin.networkmonitor.MonitorHelper;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.chromium.net.CronetEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\"B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/cloud/hisavana/protocol/intercept/CronetRetryInterceptor;", "Lokhttp3/Interceptor;", "builder", "Lcom/cloud/hisavana/protocol/intercept/CronetRetryInterceptor$Builder;", "(Lcom/cloud/hisavana/protocol/intercept/CronetRetryInterceptor$Builder;)V", "cronetInterceptor", "Lcom/cloud/hisavana/protocol/okhttptransport/CronetInterceptor;", "downCountHelper", "Lcom/cloud/hisavana/protocol/donwgrade/DownCountHelper;", "downgradePolicy", "Lcom/cloud/hisavana/protocol/donwgrade/DowngradePolicy;", "factory", "Lcom/transsin/networkmonitor/MonitorFactory;", "hostMap", "", "", "buildDownRequest", "Lokhttp3/Request;", "request", "codeDowngrade", "Lokhttp3/Response;", "response", "netDownCode", "", "chain", "Lokhttp3/Interceptor$Chain;", "customCodeDowngradePolicy", "exceptionDowngrade", "intercept", "requestDowngrade", "errorCode", "resetDownCount", "", "triggerDownCount", "Builder", "adnetwork_release"})
public final class CronetRetryInterceptor
implements Interceptor {
    @NotNull
    private final CronetInterceptor cronetInterceptor;
    @NotNull
    private final DownCountHelper downCountHelper;
    @Nullable
    private final Map<String, String> hostMap;
    @Nullable
    private MonitorFactory factory;
    @Nullable
    private DowngradePolicy downgradePolicy;

    private CronetRetryInterceptor(Builder builder) {
        this.cronetInterceptor = builder.getCronetInterceptor$adnetwork_release();
        this.downCountHelper = builder.getDownCountHelper$adnetwork_release();
        this.hostMap = builder.getHostMap$adnetwork_release();
        this.factory = builder.getFactory$adnetwork_release();
        this.downgradePolicy = builder.getDowngradePolicy$adnetwork_release();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (this.downCountHelper.isAboveLimit()) {
            CommonLogUtil.netLog((String)("request downgrade, cause failed count exceed limit, failed url is:" + chain.request().url()));
            Request request = chain.request();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request(...)");
            Request buildRequest = this.buildDownRequest(request);
            Response response = chain.proceed(buildRequest);
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"proceed(...)");
            return response;
        }
        try {
            Response response = this.cronetInterceptor.intercept(chain);
            if (response.isSuccessful()) {
                this.resetDownCount();
                Intrinsics.checkNotNull((Object)response);
                return response;
            }
            CommonLogUtil.netLog((String)("request downgrade, cause domain failed1, failed url is:" + chain.request().url()));
            Intrinsics.checkNotNull((Object)response);
            int netDownCode = NetWorkExtKt.isNetDownRequest(response);
            DowngradePolicy policy = this.downgradePolicy;
            return policy != null ? this.customCodeDowngradePolicy(response, chain, netDownCode, policy) : this.codeDowngrade(response, netDownCode, chain);
        }
        catch (Exception e) {
            Response response;
            int netDownCode = NetWorkExtKt.isNetDownRequest(e);
            if (netDownCode == -1) throw e;
            CommonLogUtil.netLog((String)("request downgrade, cause domain failed, failed url is:" + chain.request().url()));
            DowngradePolicy policy = this.downgradePolicy;
            if (policy != null) {
                if (!policy.handleCode(netDownCode)) throw e;
                response = this.exceptionDowngrade(chain, netDownCode);
                return response;
            } else {
                response = this.exceptionDowngrade(chain, netDownCode);
            }
            return response;
        }
    }

    private final Response customCodeDowngradePolicy(Response response, Interceptor.Chain chain, int netDownCode, DowngradePolicy downgradePolicy) {
        if (netDownCode == -1) {
            return response;
        }
        if (downgradePolicy.handleCode(netDownCode)) {
            this.triggerDownCount();
            return this.requestDowngrade(chain, netDownCode);
        }
        return response;
    }

    private final Response codeDowngrade(Response response, int netDownCode, Interceptor.Chain chain) {
        if (NetWorkExtKt.isNetDownCount(response)) {
            this.triggerDownCount();
            if (netDownCode != -1) {
                return this.requestDowngrade(chain, netDownCode);
            }
        }
        return response;
    }

    private final Response exceptionDowngrade(Interceptor.Chain chain, int netDownCode) {
        this.triggerDownCount();
        return this.requestDowngrade(chain, netDownCode);
    }

    private final Response requestDowngrade(Interceptor.Chain chain, int errorCode) {
        Request request = chain.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request(...)");
        Request buildRequest = this.buildDownRequest(request);
        MonitorHelper.INSTANCE.downgrade(chain, buildRequest, errorCode);
        Response response = chain.proceed(buildRequest);
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"proceed(...)");
        return response;
    }

    private final void triggerDownCount() {
        this.downCountHelper.triggerDown((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CronetRetryInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    MonitorFactory monitorFactory = CronetRetryInterceptor.access$getFactory$p(this.this$0);
                    if (monitorFactory == null) break block0;
                    monitorFactory.setCronetFilter(false);
                }
            }
        }));
    }

    private final void resetDownCount() {
        this.downCountHelper.resetCount();
    }

    private final Request buildDownRequest(Request request) {
        Request request2;
        String downHost;
        HttpUrl url = request.url();
        String host = url.host();
        Map<String, String> map = this.hostMap;
        String string = downHost = map != null ? map.get(host) : null;
        if (downHost != null) {
            Request request3 = request.newBuilder().url(url.newBuilder().host(downHost).build()).build();
            Intrinsics.checkNotNull((Object)request3);
            request2 = request3;
        } else {
            request2 = request;
        }
        return request2;
    }

    public /* synthetic */ CronetRetryInterceptor(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public static final /* synthetic */ MonitorFactory access$getFactory$p(CronetRetryInterceptor $this) {
        return $this.factory;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010\u0014J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u00020\u00002\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u000eJ\u001e\u0010,\u001a\u00020\u00002\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lcom/cloud/hisavana/protocol/intercept/CronetRetryInterceptor$Builder;", "", "engine", "Lorg/chromium/net/CronetEngine;", "(Lorg/chromium/net/CronetEngine;)V", "cronetInterceptor", "Lcom/cloud/hisavana/protocol/okhttptransport/CronetInterceptor;", "getCronetInterceptor$adnetwork_release", "()Lcom/cloud/hisavana/protocol/okhttptransport/CronetInterceptor;", "downCountHelper", "Lcom/cloud/hisavana/protocol/donwgrade/DownCountHelper;", "getDownCountHelper$adnetwork_release", "()Lcom/cloud/hisavana/protocol/donwgrade/DownCountHelper;", "downgradePolicy", "Lcom/cloud/hisavana/protocol/donwgrade/DowngradePolicy;", "getDowngradePolicy$adnetwork_release", "()Lcom/cloud/hisavana/protocol/donwgrade/DowngradePolicy;", "setDowngradePolicy$adnetwork_release", "(Lcom/cloud/hisavana/protocol/donwgrade/DowngradePolicy;)V", "factory", "Lcom/transsin/networkmonitor/MonitorFactory;", "getFactory$adnetwork_release", "()Lcom/transsin/networkmonitor/MonitorFactory;", "setFactory$adnetwork_release", "(Lcom/transsin/networkmonitor/MonitorFactory;)V", "hostMap", "", "", "getHostMap$adnetwork_release", "()Ljava/util/Map;", "setHostMap$adnetwork_release", "(Ljava/util/Map;)V", "build", "Lcom/cloud/hisavana/protocol/intercept/CronetRetryInterceptor;", "eventListenerFactory", "eventFactory", "setDowngradeCount", "limitDownCount", "", "setDowngradeListener", "listener", "Lcom/cloud/hisavana/protocol/donwgrade/CronetInterceptListener;", "setDowngradePolicy", "policy", "setHostMap", "adnetwork_release"})
    public static final class Builder {
        @NotNull
        private final CronetInterceptor cronetInterceptor;
        @NotNull
        private final DownCountHelper downCountHelper;
        @Nullable
        private Map<String, String> hostMap;
        @Nullable
        private MonitorFactory factory;
        @Nullable
        private DowngradePolicy downgradePolicy;

        public Builder(@NotNull CronetEngine engine) {
            Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
            Object ObjectBeingBuiltT = CronetInterceptor.newBuilder(engine).build();
            Intrinsics.checkNotNullExpressionValue(ObjectBeingBuiltT, (String)"build(...)");
            this.cronetInterceptor = (CronetInterceptor)ObjectBeingBuiltT;
            this.downCountHelper = new DownCountHelper();
        }

        @NotNull
        public final CronetInterceptor getCronetInterceptor$adnetwork_release() {
            return this.cronetInterceptor;
        }

        @NotNull
        public final DownCountHelper getDownCountHelper$adnetwork_release() {
            return this.downCountHelper;
        }

        @Nullable
        public final Map<String, String> getHostMap$adnetwork_release() {
            return this.hostMap;
        }

        public final void setHostMap$adnetwork_release(@Nullable Map<String, String> map) {
            this.hostMap = map;
        }

        @Nullable
        public final MonitorFactory getFactory$adnetwork_release() {
            return this.factory;
        }

        public final void setFactory$adnetwork_release(@Nullable MonitorFactory monitorFactory) {
            this.factory = monitorFactory;
        }

        @Nullable
        public final DowngradePolicy getDowngradePolicy$adnetwork_release() {
            return this.downgradePolicy;
        }

        public final void setDowngradePolicy$adnetwork_release(@Nullable DowngradePolicy downgradePolicy) {
            this.downgradePolicy = downgradePolicy;
        }

        @NotNull
        public final Builder setHostMap(@Nullable Map<String, String> hostMap) {
            this.hostMap = hostMap;
            return this;
        }

        public static /* synthetic */ Builder setHostMap$default(Builder builder, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = null;
            }
            return builder.setHostMap(map);
        }

        @NotNull
        public final Builder setDowngradeCount(int limitDownCount) {
            this.downCountHelper.setLimitDownCount$adnetwork_release(limitDownCount);
            return this;
        }

        @NotNull
        public final Builder setDowngradeListener(@Nullable CronetInterceptListener listener) {
            this.downCountHelper.setListener$adnetwork_release(listener);
            return this;
        }

        public static /* synthetic */ Builder setDowngradeListener$default(Builder builder, CronetInterceptListener cronetInterceptListener, int n, Object object) {
            if ((n & 1) != 0) {
                cronetInterceptListener = null;
            }
            return builder.setDowngradeListener(cronetInterceptListener);
        }

        @NotNull
        public final Builder setDowngradePolicy(@NotNull DowngradePolicy policy) {
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            this.downgradePolicy = policy;
            return this;
        }

        @NotNull
        public final Builder eventListenerFactory(@Nullable MonitorFactory eventFactory) {
            if (eventFactory == null) {
                return this;
            }
            eventFactory.setCronetFilter(true);
            this.factory = eventFactory;
            return this;
        }

        @NotNull
        public final CronetRetryInterceptor build() {
            return new CronetRetryInterceptor(this, null);
        }
    }
}

