/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import android.util.Log;
import com.cloud.hisavana.protocol.okhttptransport.CronetTransportResponseBody;
import com.cloud.hisavana.protocol.okhttptransport.RequestResponseConverter;
import com.cloud.hisavana.protocol.okhttptransport.RequestResponseConverterBasedBuilder;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.AsyncTimeout;
import okio.Timeout;
import org.chromium.net.CronetEngine;

public final class CronetCallFactory
implements Call.Factory {
    private static final String TAG = "CronetCallFactory";
    private final RequestResponseConverter converter;
    private final ExecutorService responseCallbackExecutor;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int callTimeoutMillis;

    private CronetCallFactory(RequestResponseConverter converter, ExecutorService responseCallbackExecutor, int readTimeoutMillis, int writeTimeoutMillis, int callTimeoutMillis) {
        Preconditions.checkArgument((readTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Read timeout mustn't be negative!");
        Preconditions.checkArgument((writeTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Write timeout mustn't be negative!");
        Preconditions.checkArgument((callTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Call timeout mustn't be negative!");
        this.converter = converter;
        this.responseCallbackExecutor = responseCallbackExecutor;
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.callTimeoutMillis = callTimeoutMillis;
    }

    public static Builder newBuilder(CronetEngine cronetEngine) {
        return new Builder(cronetEngine);
    }

    public Call newCall(Request request) {
        return new CronetCall(request, this, this.converter, this.responseCallbackExecutor);
    }

    private static Response toCronetCallFactoryResponse(final CronetCall call, Response response) {
        Preconditions.checkNotNull((Object)response.body());
        return response.newBuilder().body((ResponseBody)new CronetTransportResponseBody(response.body()){

            @Override
            void customCloseHook() {
                call.timeout.exit();
            }
        }).build();
    }

    private static class CronetCall
    implements Call {
        private final Request okHttpRequest;
        private final CronetCallFactory motherFactory;
        private final RequestResponseConverter converter;
        private final ExecutorService responseCallbackExecutor;
        private final AtomicBoolean executed = new AtomicBoolean();
        private final AtomicBoolean canceled = new AtomicBoolean();
        private final AtomicReference<RequestResponseConverter.CronetRequestAndOkHttpResponse> convertedRequestAndResponse = new AtomicReference();
        private final AsyncTimeout timeout;

        private CronetCall(Request okHttpRequest, CronetCallFactory motherFactory, RequestResponseConverter converter, ExecutorService responseCallbackExecutor) {
            this.okHttpRequest = okHttpRequest;
            this.motherFactory = motherFactory;
            this.converter = converter;
            this.responseCallbackExecutor = responseCallbackExecutor;
            this.timeout = new AsyncTimeout(){

                protected void timedOut() {
                    this.cancel();
                }
            };
            this.timeout.timeout((long)motherFactory.callTimeoutMillis, TimeUnit.MILLISECONDS);
        }

        public Request request() {
            return this.okHttpRequest;
        }

        public Response execute() throws IOException {
            this.evaluateExecutionPreconditions();
            try {
                this.timeout.enter();
                RequestResponseConverter.CronetRequestAndOkHttpResponse requestAndOkHttpResponse = this.converter.convert(this.request(), this.motherFactory.readTimeoutMillis, this.motherFactory.writeTimeoutMillis);
                this.convertedRequestAndResponse.set(requestAndOkHttpResponse);
                this.startRequestIfNotCanceled();
                return CronetCallFactory.toCronetCallFactoryResponse(this, requestAndOkHttpResponse.getResponse());
            }
            catch (IOException | RuntimeException e) {
                this.timeout.exit();
                throw e;
            }
        }

        public void enqueue(final Callback responseCallback) {
            try {
                this.timeout.enter();
                this.evaluateExecutionPreconditions();
                RequestResponseConverter.CronetRequestAndOkHttpResponse requestAndOkHttpResponse = this.converter.convert(this.request(), this.motherFactory.readTimeoutMillis, this.motherFactory.writeTimeoutMillis);
                this.convertedRequestAndResponse.set(requestAndOkHttpResponse);
                final CronetCall call = this;
                Futures.addCallback(requestAndOkHttpResponse.getResponseAsync(), (FutureCallback)new FutureCallback<Response>(){

                    public void onSuccess(Response result) {
                        try {
                            responseCallback.onResponse((Call)call, CronetCallFactory.toCronetCallFactoryResponse(call, result));
                        }
                        catch (IOException e) {
                            Log.i((String)CronetCallFactory.TAG, (String)("Callback failure for " + this.toLoggableString()), (Throwable)e);
                        }
                    }

                    public void onFailure(Throwable t) {
                        if (t instanceof IOException) {
                            responseCallback.onFailure((Call)call, (IOException)t);
                        } else {
                            responseCallback.onFailure((Call)call, new IOException(t));
                        }
                    }
                }, (Executor)this.responseCallbackExecutor);
                this.startRequestIfNotCanceled();
            }
            catch (IOException e) {
                this.timeout.exit();
                responseCallback.onFailure((Call)this, e);
            }
        }

        public Call clone() {
            return this.motherFactory.newCall(this.request());
        }

        public void cancel() {
            if (this.canceled.getAndSet(true)) {
                return;
            }
            RequestResponseConverter.CronetRequestAndOkHttpResponse localConverted = this.convertedRequestAndResponse.get();
            if (localConverted != null) {
                localConverted.getRequest().cancel();
            }
        }

        public boolean isExecuted() {
            return this.executed.get();
        }

        public boolean isCanceled() {
            return this.canceled.get();
        }

        public Timeout timeout() {
            return this.timeout;
        }

        private String toLoggableString() {
            return "call to " + this.request().url().redact();
        }

        private void evaluateExecutionPreconditions() throws IOException {
            if (this.canceled.get()) {
                throw new IOException("Can't execute canceled requests");
            }
            Preconditions.checkState((!this.executed.getAndSet(true) ? 1 : 0) != 0, (Object)"Already Executed");
        }

        private void startRequestIfNotCanceled() {
            RequestResponseConverter.CronetRequestAndOkHttpResponse requestAndOkHttpResponse = this.convertedRequestAndResponse.get();
            Preconditions.checkState((requestAndOkHttpResponse != null ? 1 : 0) != 0, (Object)"convertedRequestAndResponse must be set!");
            if (this.canceled.get()) {
                requestAndOkHttpResponse.getRequest().cancel();
            } else {
                requestAndOkHttpResponse.getRequest().start();
            }
        }
    }

    public static final class Builder
    extends RequestResponseConverterBasedBuilder<Builder, CronetCallFactory> {
        private static final int DEFAULT_READ_WRITE_TIMEOUT_MILLIS = 10000;
        private int readTimeoutMillis = 10000;
        private int writeTimeoutMillis = 10000;
        private int callTimeoutMillis = 0;
        private ExecutorService callbackExecutorService = null;

        Builder(CronetEngine cronetEngine) {
            super(cronetEngine, Builder.class);
        }

        public Builder setReadTimeoutMillis(int readTimeoutMillis) {
            Preconditions.checkArgument((readTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Read timeout mustn't be negative!");
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public Builder setWriteTimeoutMillis(int writeTimeoutMillis) {
            Preconditions.checkArgument((writeTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Write timeout mustn't be negative!");
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public Builder setCallbackExecutorService(ExecutorService callbackExecutorService) {
            Preconditions.checkNotNull((Object)callbackExecutorService);
            this.callbackExecutorService = callbackExecutorService;
            return this;
        }

        public Builder setCallTimeoutMillis(int callTimeoutMillis) {
            Preconditions.checkArgument((callTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"Call timeout mustn't be negative!");
            this.callTimeoutMillis = callTimeoutMillis;
            return this;
        }

        @Override
        CronetCallFactory build(RequestResponseConverter converter) {
            ExecutorService localCallbackExecutorService = this.callbackExecutorService == null ? Executors.newCachedThreadPool() : this.callbackExecutorService;
            return new CronetCallFactory(converter, localCallbackExecutorService, this.readTimeoutMillis, this.writeTimeoutMillis, this.callTimeoutMillis);
        }
    }
}

