/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

import android.util.Pair;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;

final class UploadBodyDataBroker
implements Sink {
    private final BlockingQueue<Pair<ByteBuffer, SettableFuture<ReadResult>>> pendingRead = new ArrayBlockingQueue<Pair<ByteBuffer, SettableFuture<ReadResult>>>(1);
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicReference<Throwable> backgroundReadThrowable = new AtomicReference();

    UploadBodyDataBroker() {
    }

    Future<ReadResult> enqueueBodyRead(ByteBuffer readBuffer) {
        Throwable backgroundThrowable = this.backgroundReadThrowable.get();
        if (backgroundThrowable != null) {
            return Futures.immediateFailedFuture((Throwable)backgroundThrowable);
        }
        SettableFuture future = SettableFuture.create();
        this.pendingRead.add((Pair<ByteBuffer, SettableFuture<ReadResult>>)Pair.create((Object)readBuffer, (Object)future));
        backgroundThrowable = this.backgroundReadThrowable.get();
        if (backgroundThrowable != null) {
            future.setException(backgroundThrowable);
        }
        return future;
    }

    void setBackgroundReadError(Throwable t) {
        this.backgroundReadThrowable.set(t);
        Pair read = (Pair)this.pendingRead.poll();
        if (read != null) {
            ((SettableFuture)read.second).setException(t);
        }
    }

    void handleEndOfStreamSignal() throws IOException {
        if (this.isClosed.getAndSet(true)) {
            throw new IllegalStateException("Already closed");
        }
        ((SettableFuture)this.getPendingCronetRead().second).set((Object)ReadResult.END_OF_BODY);
    }

    public void write(Buffer source, long byteCount) throws IOException {
        long bytesRead;
        Preconditions.checkState((!this.isClosed.get() ? 1 : 0) != 0);
        for (long bytesRemaining = byteCount; bytesRemaining != 0L; bytesRemaining -= bytesRead) {
            Pair<ByteBuffer, SettableFuture<ReadResult>> payload = this.getPendingCronetRead();
            ByteBuffer readBuffer = (ByteBuffer)payload.first;
            SettableFuture future = (SettableFuture)payload.second;
            int originalBufferLimit = readBuffer.limit();
            int bytesToDrain = (int)Math.min((long)originalBufferLimit, bytesRemaining);
            readBuffer.limit(bytesToDrain);
            try {
                bytesRead = source.read(readBuffer);
                if (bytesRead == -1L) {
                    IOException e = new IOException("The source has been exhausted but we expected more!");
                    future.setException((Throwable)e);
                    throw e;
                }
                readBuffer.limit(originalBufferLimit);
                future.set((Object)ReadResult.SUCCESS);
                continue;
            }
            catch (IOException e) {
                future.setException((Throwable)e);
                throw e;
            }
        }
    }

    private Pair<ByteBuffer, SettableFuture<ReadResult>> getPendingCronetRead() throws IOException {
        try {
            return this.pendingRead.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for a read to finish!");
        }
    }

    public void close() {
        this.isClosed.set(true);
    }

    public void flush() {
    }

    public Timeout timeout() {
        return Timeout.NONE;
    }

    static enum ReadResult {
        SUCCESS,
        END_OF_BODY;

    }
}

