package com.cloud.hisavana.net.disklrucache.impl;


/**
 * 构建DiskLruCache
 * @author chenshijun
 */
public class DiskLruCacheFactory implements IDiskCache.Factory {

    private final long diskCacheSize;
    private final int  cacheMode;

    public DiskLruCacheFactory(long cacheMaxSize, int cacheMode) {
        this.diskCacheSize = cacheMaxSize;
        this.cacheMode = cacheMode;
    }

    @Override
    public IDiskCache build() {
        return new DiskCacheImpl(null, diskCacheSize, cacheMode);
    }
}
