package com.cloud.hisavana.protocol.extension

import okhttp3.ConnectionSpec
import okhttp3.OkHttpClient.Builder
import okhttp3.Protocol
import okhttp3.TlsVersion

/**
 * 是否支持Http2.0协议
 */
fun Builder.enableH2(enable: Boolean): Builder {
    if (!enable) {
        this.protocols(listOf(Protocol.HTTP_1_1))
    } else {
        this.protocols(listOf(Protocol.HTTP_2, Protocol.HTTP_1_1))
    }
    return this
}

/**
 * 是否支持tls1.3
 */
fun Builder.enableTls13(enable: Boolean): Builder {
    if (!enable) {
        val spec = ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS)
            .tlsVersions(TlsVersion.TLS_1_2)
            .build()
        this.connectionSpecs(mutableListOf(spec, ConnectionSpec.CLEARTEXT))
    } else {
        this.connectionSpecs(listOf(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT))
    }
    return this
}