package com.cloud.hisavana.protocol.intercept

import com.cloud.sdk.commonutil.util.CommonLogUtil
import com.transsin.networkmonitor.ErrorCode
import com.transsin.networkmonitor.MonitorHelper
import okhttp3.Interceptor
import okhttp3.Response
import java.net.UnknownHostException

/**
 * 域名重试拦截器
 */
class DomainRetryIntercept(
    private val hostMap: Map<String, String>
):Interceptor {

    override fun intercept(chain: Interceptor.Chain): Response {
        try {
            return chain.proceed(chain.request())
        } catch (e: Exception) {
            val url = chain.request().url()
            val host = url.host()
            val downHost = hostMap[host]
            if (downHost != null && e is UnknownHostException) {
                val buildRequest = chain.request().newBuilder()
                    .url(url.newBuilder().host(downHost).build())
                    .build().apply {
                        CommonLogUtil.netLog("request downgrade, domain failed, failed url is:${chain.request().url()}")
                        MonitorHelper.downgrade(chain, this, ErrorCode.CODE_UNKNOWN_HOST)
                    }
                return chain.proceed(buildRequest)
            }else{
                throw e
            }
        }
    }
}