package com.cloud.hisavana.net.disklrucache.impl;


import com.cloud.hisavana.net.HttpRequest;

/**
 * 提供缓存池
 *
 * @author chenshijun
 */
public class DiskCacheProvider implements IDiskCache.Provider {

    /**
     * 默认缓存池
     */
    private volatile IDiskCache normalDiskCache;

    /**
     * 视频缓存池
     */
    private volatile IDiskCache videoDiskCache;

    /**
     * 内置广告缓存池
     */
    private volatile IDiskCache defaultDiskCache;

    @Override
    public IDiskCache getDiskCache(long cacheMaxSize, int cacheMode) {
        switch (cacheMode) {
            case HttpRequest.DEFAULT_MODE:
                return getDefaultDiskCache(cacheMaxSize);
            case HttpRequest.VIDEO_MODE:
                return getVideoDiskCache(cacheMaxSize);
            default:
                return getOnLineDiskCache(cacheMaxSize);
        }
    }

    private IDiskCache getOnLineDiskCache(long cacheMaxSize) {
        if (normalDiskCache == null) {
            synchronized (this) {
                if (normalDiskCache == null) {
                    normalDiskCache = new DiskLruCacheFactory(cacheMaxSize, HttpRequest.ONLINE_MODE).build();
                }
            }
        }
        return normalDiskCache;
    }

    private IDiskCache getVideoDiskCache(long cacheMaxSize) {
        if (videoDiskCache == null) {
            synchronized (this) {
                if (videoDiskCache == null) {
                    videoDiskCache = new DiskLruCacheFactory(cacheMaxSize, HttpRequest.VIDEO_MODE).build();
                }
            }
        }
        return videoDiskCache;
    }

    private IDiskCache getDefaultDiskCache(long cacheMaxSize) {
        if (defaultDiskCache == null) {
            synchronized (this) {
                if (defaultDiskCache == null) {
                    defaultDiskCache = new DiskLruCacheFactory(cacheMaxSize, HttpRequest.DEFAULT_MODE).build();
                }
            }
        }
        return defaultDiskCache;
    }
}
