package com.cloud.hisavana.protocol.extension

import com.transsin.networkmonitor.ErrorCode
import okhttp3.Response
import java.lang.Exception

/**
 * 没有触发降级的Code
 */
const val NONE_NET_DOWN_CODE = -1

/**
 * 网络请求错误码触发网络错误计数
 */
fun Response.isNetDownCount(): Boolean {
    return !isServerLimit() && code() in 400..599
}

/**
 * 网络请求错误码触发网络降级请求：(降级OKhttp，降级域名)
 */
fun Response.isNetDownRequest(): Int {
    return if (!isServerLimit() && (code() in 400..499 || code() == 505)) {
        code()
    } else {
        NONE_NET_DOWN_CODE
    }
}

/**
 * 网络请求错误码服务器限流
 */
fun Response.isServerLimit(): Boolean {
    return code() == 429
}

val errorCronetList = listOf(
    "ERR_NAME_NOT_RESOLVED",
    "ERR_TIMED_OUT",
    "ERR_CONNECTION_CLOSED",
    "ERR_CONNECTION_TIMED_OUT",
    "ERR_CONNECTION_REFUSED",
    "ERR_CONNECTION_RESET",
    "ERR_ADDRESS_UNREACHABLE",
    "ERR_QUIC_PROTOCOL_ERROR"
)

/**
 * Cronet请求需要降级的异常
 */
fun Exception.isNetDownRequest(): Int {
    return when (errorCronetList.find { message?.contains(it) == true }) {
        "ERR_NAME_NOT_RESOLVED" -> ErrorCode.CODE_UNKNOWN_HOST
        "ERR_TIMED_OUT" -> ErrorCode.CODE_SOCKET_TIME_OUT
        "ERR_CONNECTION_TIMED_OUT" -> ErrorCode.CODE_CONNECT_TIMEOUT_EXCEPTION
        "ERR_CONNECTION_CLOSED" -> ErrorCode.CODE_CONNECT_CLOSED
        "ERR_CONNECTION_REFUSED" -> ErrorCode.CODE_CONNECT_REFUSED
        "ERR_CONNECTION_RESET" -> ErrorCode.CODE_CONNECT_RESET
        "ERR_ADDRESS_UNREACHABLE" -> ErrorCode.CODE_NO_ROUTE_TO_HOST
        "ERR_QUIC_PROTOCOL_ERROR" -> ErrorCode.CODE_PROTOCOL_ERROR
        else -> NONE_NET_DOWN_CODE
    }
}