package com.cloud.hisavana.protocol.donwgrade

import java.util.concurrent.atomic.AtomicInteger

/**
 * 记录网络请求降级请求的计数器
 */
class DownCountHelper {

    internal var limitDownCount: Int = 10
    internal var listener: CronetInterceptListener? = null

    //网络请求的计数器。
    private var downLimit = AtomicInteger(0)
    fun isAboveLimit(): Boolean {
        return downLimit.get() >= limitDownCount
    }

    fun resetCount() {
        downLimit.set(0)
    }

    fun triggerDown(downCallBack: () -> Unit) {
        val newLimit = downLimit.incrementAndGet()
        if (newLimit >= limitDownCount) {
            listener?.onDowngrade()
            downCallBack.invoke()
        }
    }
}