package com.cloud.hisavana.net

import android.content.Context
import com.cloud.sdk.commonutil.control.AdxPreferencesHelper
import com.cloud.hisavana.protocol.donwgrade.DowngradePolicy
import com.cloud.hisavana.protocol.intercept.CronetRetryInterceptor
import com.cloud.hisavana.protocol.intercept.DomainIntercept
import com.cloud.hisavana.protocol.intercept.DomainRetryIntercept
import com.cloud.hisavana.protocol.okhttptransport.CronetInterceptor
import com.cloud.sdk.commonutil.util.CommonLogUtil
import com.cloud.sdk.commonutil.util.HSCoreUtil
import com.transsin.networkmonitor.CronetMonitorHelper
import com.transsin.networkmonitor.ErrorCode
import com.transsin.networkmonitor.MonitorFactory
import okhttp3.OkHttpClient
import org.chromium.net.CronetEngine
import org.chromium.net.RequestFinishedInfo
import java.util.concurrent.Executors

const val NET_API_QUIC = "api-quic.hisavana.com" // quic域名，支持http3
const val NET_API = "api.hisavana.com" // 不支持http3

const val NET_API_QUIC_EW = "creative.eagllwin.com" // quic域名，支持http3

const val NET_API_QUIC_ADX = "hisavana-adx.transacme.com" // quic域名，支持http3

const val GROUP_OKHTTP = 1013 // okhttp
const val GROUP_OKHTTP_RETRY = 1014 // okhttp + 重试
const val GROUP_CRONET = 1015 // cronet
const val GROUP_CRONET_RETRY = 1016 // cronet + 重试
const val CHANNEL = "All" // 业务方渠道标识
// 网络优化 AB测试开关
const val AB_TEST_ENABLE = "abTestEnable"
// 分桶
const val GROUP_BUCKET = "bucket"

/************** 测试数据 *************/
const val CONTROL_TYPE = "controlType"
const val HAND_CONTROL = "handControl"

const val NET_RETRY_DOMAIN = "retry_domain"
var api = ""
/************** 测试数据 *************/

/**
 * 网络分组
 */
object NetGroup {

    @JvmStatic
    var abTestEnable: Boolean = false // 云控默认开关
    @JvmStatic
    var groupBucketId: Int = 0 // 分桶项

    // 实验通道
    @JvmStatic
    fun getTestChannel(): Int {
        // 网络优化 AB测试开关
        abTestEnable = AdxPreferencesHelper.getInstance().getBoolean(AB_TEST_ENABLE, false)
//        groupBucketId = if (abTestEnable) {
//            // 接口保存的实验桶id
//            AdxPreferencesHelper.getInstance().getInt(GROUP_BUCKET)
//        } else {
//            0
//        }
        groupBucketId = 0 // 3360 版本关闭实验，这里直接赋值为 0
        CommonLogUtil.netLog("NetGroup Net Init：abTestEnable = $abTestEnable \t groupBucketId = $groupBucketId")
        return groupBucketId
    }

    // 实验分组
    @JvmStatic
    fun getWrapBuilder(
        builder: OkHttpClient.Builder?,
        factory: MonitorFactory?,
        testChannel: Int, // 实验通道
    ): OkHttpClient.Builder? {
        // AB的标识字段
        factory?.setABTag(GROUP_OKHTTP.toString())
        return when (testChannel) {
            // Okhttp + 域名重试
            GROUP_OKHTTP_RETRY -> {
                // AB的标识字段
                factory?.setABTag(GROUP_OKHTTP_RETRY.toString())
                // 添加域名拦截器，内部会实现域名请求失败的降级；域名映射到重试域名
                builder?.addInterceptor(DomainRetryIntercept(mapOf(Pair(NET_API, NET_API_QUIC))))
            }
            // Cronet
            GROUP_CRONET -> {
                val engine = buildCronetEngine(HSCoreUtil.getContext(), GROUP_CRONET.toString()) ?: return builder
                // AB的标识字段
                factory?.setABTag(GROUP_CRONET.toString())
                // 过滤Okhttp请求的上报
                factory?.setCronetFilter(true)
                // 添加域名拦截器，内部会实现新旧域名的替换；旧域名映射到新域名
                builder?.addInterceptor(DomainIntercept(mapOf(Pair(NET_API, NET_API_QUIC))))
                // 添加Cronet拦截器到Okhttp的Builder中去，放在拦截器的最后一个位置
                builder?.addInterceptor(CronetInterceptor.newBuilder(engine).build())
            }
            // Cronet + 域名重试
            GROUP_CRONET_RETRY -> {
                val engine = buildCronetEngine(HSCoreUtil.getContext(), GROUP_CRONET_RETRY.toString()) ?: return builder
                factory?.setABTag(GROUP_CRONET_RETRY.toString())
                // 添加域名拦截器，内部会实现新旧域名的替换
                builder?.addInterceptor(DomainIntercept(mapOf(Pair(NET_API, NET_API_QUIC))))
                // 添加Cronet拦截器到Okhttp的Builder中去，放在拦截器的最后一个位置
                builder?.addInterceptor(CronetRetryInterceptor.Builder(engine)
                    // map的key是新域名，value是老域名。
                    .setHostMap(mapOf(Pair(NET_API_QUIC, NET_API)))
                    // 自定义降级Code，默认的降级Code如下表所示，可以自行自定义哪些Code需要降级，哪些Code不需要降级
                    // (比如：示例代码中只有域名解析失败才降级重试)
                    .setDowngradePolicy(object : DowngradePolicy {
                        override fun handleCode(code: Int): Boolean {
                            return code == ErrorCode.CODE_UNKNOWN_HOST
                        }

                    })
                    .eventListenerFactory(factory)
                    .build()
                )
            }
            // Okhttp
            else -> builder
        }
    }

    // 构建cronet引擎
    private fun buildCronetEngine(context: Context, group: String): CronetEngine? {
        // 建议使用try catch的方式创建CronetEngine，避免系统不支持cronet内核共享，如果内核创建失败，就使用Okhttp请求。
        return runCatching {
            CronetEngine.Builder(context)
                .enableHttp2(true)
                // 是否开启quic协议支持。如果是AB实验，这里传入是否支持开启quic的值
                .enableQuic(true)
                // 如果开启了quic协议支持，这里传入支持quic协议的域名，会跳过quic协议协商，默认用quic协议建立连接
                .addQuicHint(NET_API_QUIC, 443, 443)
                .addQuicHint(NET_API_QUIC_EW, 443, 443)
                .addQuicHint(NET_API_QUIC_ADX, 443, 443)
                .build().apply {
                    this.addRequestFinishedListener(object : RequestFinishedInfo.Listener(Executors.newSingleThreadExecutor()) {
                        override fun onRequestFinished(requestInfo: RequestFinishedInfo?) {
                            if (requestInfo == null) return
                            // 添加Cronet的网络网络监控，如果是AB实验，这里可以传入abTag来标识这个是ab的数据。
                            // abtag用于线上的AB数据归因：比如开启了h2和h3的AB实验，这里可以传入“cronet-h2”或者“croent-h3”
                            CronetMonitorHelper.logMatrix(requestInfo, 0, CHANNEL, group, CommonOkHttpClient.isTestRequest)
                        }

                    })
                }
        }.getOrNull()
    }

    /**
     * 广告域名白名单
     */
    @JvmStatic
    fun adsDomainWhite(url: String?): Boolean {
        if (url.isNullOrBlank()) return false
        return url.contains(NET_API, true) || url.contains(NET_API_QUIC, true)
    }
}