/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.protocol.okhttptransport;

public abstract class RedirectStrategy {
    private static final int DEFAULT_REDIRECTS = 16;

    abstract boolean followRedirects();

    abstract int numberOfRedirectsToFollow();

    public static RedirectStrategy withoutRedirects() {
        return WithoutRedirectsHolder.INSTANCE;
    }

    public static RedirectStrategy defaultStrategy() {
        return DefaultRedirectsHolder.INSTANCE;
    }

    private RedirectStrategy() {
    }

    private static class WithoutRedirectsHolder {
        private static final RedirectStrategy INSTANCE = new RedirectStrategy(){

            @Override
            boolean followRedirects() {
                return false;
            }

            @Override
            int numberOfRedirectsToFollow() {
                throw new UnsupportedOperationException();
            }
        };

        private WithoutRedirectsHolder() {
        }
    }

    private static class DefaultRedirectsHolder {
        private static final RedirectStrategy INSTANCE = new RedirectStrategy(){

            @Override
            boolean followRedirects() {
                return true;
            }

            @Override
            int numberOfRedirectsToFollow() {
                return 16;
            }
        };

        private DefaultRedirectsHolder() {
        }
    }
}

