package com.cloud.hisavana.net.disklrucache.utils;

import android.util.Log;
import android.util.LruCache;

import com.cloud.hisavana.net.disklrucache.ImageCacheURL;
import com.cloud.sdk.commonutil.util.CommonLogUtil;

import java.security.MessageDigest;


/**
 * url 地址安全转化
 *
 * @author chenshijun
 */
public class SafeKeyUtils {
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final LruCache<ImageCacheURL, String> loadIdToSafeHash = new LruCache<>(1000);

    public static String getSafeKey(ImageCacheURL imageCacheURL) {
        String safeKey;
        synchronized (loadIdToSafeHash) {
            safeKey = loadIdToSafeHash.get(imageCacheURL);
        }
        if (safeKey == null) {
            safeKey = calculateHexStringDigest(imageCacheURL);
        }
        synchronized (loadIdToSafeHash) {
            loadIdToSafeHash.put(imageCacheURL, safeKey);
        }
        return safeKey;
    }

    private static String calculateHexStringDigest(ImageCacheURL imageCacheURL) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            messageDigest.update(imageCacheURL.getCacheKeyBytes());
            byte[] hashedData = messageDigest.digest();
            return DiskLruCacheUtil.sha256BytesToHex(hashedData);
        } catch (Exception e) {
            CommonLogUtil.netLog("calculateHexStringDigest: " + Log.getStackTraceString(e));
            return "";
        }
    }

}