/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.util;

import android.util.Log;
import com.cloud.hisavana.http.cache.j;
import com.cloud.hisavana.http.util.Pools;
import java.util.ArrayList;
import java.util.List;

public final class FactoryPools {
    private static final String TAG = "FactoryPools";
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final Resetter<Object> EMPTY_RESETTER = new Resetter<Object>(){

        @Override
        public final void reset(Object object) {
        }
    };

    private FactoryPools() {
    }

    public static <T extends Poolable> Pools.Pool<T> simple(int n, Factory<T> factory) {
        return FactoryPools.build(new Pools.SimplePool(n), factory);
    }

    public static <T extends Poolable> Pools.Pool<T> threadSafe(int n, Factory<T> factory) {
        return FactoryPools.build(new Pools.SynchronizedPool(n), factory);
    }

    public static <T> Pools.Pool<List<T>> threadSafeList() {
        return FactoryPools.threadSafeList(20);
    }

    public static <T> Pools.Pool<List<T>> threadSafeList(int n) {
        return FactoryPools.build(new Pools.SynchronizedPool(n), new Factory<List<T>>(){

            @Override
            public final /* synthetic */ Object create() {
                return new ArrayList();
            }
        }, new Resetter<List<T>>(){

            @Override
            public final /* synthetic */ void reset(Object object) {
                object = (List)object;
                object.clear();
            }
        });
    }

    private static <T extends Poolable> Pools.Pool<T> build(Pools.Pool<T> pool, Factory<T> factory) {
        return FactoryPools.build(pool, factory, FactoryPools.emptyResetter());
    }

    private static <T> Pools.Pool<T> build(Pools.Pool<T> pool, Factory<T> factory, Resetter<T> resetter) {
        return new a<T>(pool, factory, resetter);
    }

    private static <T> Resetter<T> emptyResetter() {
        return EMPTY_RESETTER;
    }

    static final class a<T>
    implements Pools.Pool<T> {
        private final Factory<T> a;
        private final Resetter<T> b;
        private final Pools.Pool<T> c;

        a(Pools.Pool<T> pool, Factory<T> factory, Resetter<T> resetter) {
            this.c = pool;
            this.a = factory;
            this.b = resetter;
        }

        @Override
        public final T acquire() {
            T t = this.c.acquire();
            if (t == null) {
                t = this.a.create();
                if (Log.isLoggable((String)FactoryPools.TAG, (int)2)) {
                    Log.v((String)FactoryPools.TAG, (String)("Created new " + t.getClass()));
                }
            }
            if (t instanceof Poolable) {
                ((Poolable)t).getVerifier().a(false);
            }
            return t;
        }

        @Override
        public final boolean release(T t) {
            if (t instanceof Poolable) {
                ((Poolable)t).getVerifier().a(true);
            }
            this.b.reset(t);
            return this.c.release(t);
        }
    }

    public static interface Poolable {
        public j getVerifier();
    }

    public static interface Resetter<T> {
        public void reset(T var1);
    }

    public static interface Factory<T> {
        public T create();
    }
}

