/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.impl;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.cloud.hisavana.http.impl.IHttpCallback;
import com.cloud.hisavana.http.log.Console;
import com.cloud.hisavana.http.util.CheckUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class HttpCallbackImpl
implements IHttpCallback {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String UTF8_BOM = "\ufeff";
    private Handler a;
    private boolean b;
    private boolean c;
    private Looper d = null;

    public HttpCallbackImpl() {
        this(null);
    }

    public HttpCallbackImpl(Looper looper) {
        this(looper == null ? Looper.myLooper() : looper, false);
    }

    public HttpCallbackImpl(boolean bl) {
        this(bl ? null : Looper.myLooper(), bl);
    }

    private HttpCallbackImpl(Looper looper, boolean bl) {
        if (!bl) {
            CheckUtil.asserts(looper != null, "use looper thread, must call Looper.prepare() first!");
            this.d = looper;
            this.a = new a(this, looper);
        } else {
            CheckUtil.asserts(looper == null, "use pool thread, looper should be null!");
            this.d = null;
            this.a = null;
        }
        this.c = bl;
    }

    @Override
    public void setUseSyncMode(boolean bl) {
        if (!bl && this.d == null) {
            bl = true;
            Console.log.w("HttpCallbackImpl", "Current thread has not called Looper.prepare(). Forcing synchronous mode.");
        }
        if (!bl && this.a == null) {
            HttpCallbackImpl httpCallbackImpl = this;
            this.a = new a(httpCallbackImpl, httpCallbackImpl.d);
        } else if (bl && this.a != null) {
            this.a = null;
        }
        this.b = bl;
    }

    @Override
    public boolean getUseSyncMode() {
        return this.b;
    }

    @Override
    public boolean getUsePoolThread() {
        return this.c;
    }

    @Override
    public void setUsePoolThread(boolean bl) {
        if (bl) {
            this.d = null;
            this.a = null;
        }
        this.c = bl;
    }

    public abstract void onSuccess(int var1, byte[] var2);

    public void onSuccess(int n, byte[] byArray, String string) {
    }

    public void onResponseHeader(Map<String, List<String>> map) {
    }

    public abstract void onFailure(int var1, byte[] var2, Throwable var3);

    @Override
    public void sendSuccessMessage(int n, byte[] byArray) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(0, new Object[]{n, byArray}));
    }

    @Override
    public void sendSuccessMessage(int n, byte[] byArray, String string) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(0, new Object[]{n, byArray, string}));
    }

    @Override
    public void sendSuccessMessage(int n, byte[] byArray, Map<String, List<String>> map) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(0, new Object[]{n, byArray, map}));
    }

    @Override
    public void sendFailureMessage(int n, byte[] byArray, Throwable throwable) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(1, new Object[]{n, byArray, throwable}));
    }

    @Override
    public void sendFailureMessage(int n, byte[] byArray, Throwable throwable, Map<String, List<String>> map) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(1, new Object[]{n, byArray, throwable, map}));
    }

    @Override
    public void sendStartMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(2, null));
    }

    @Override
    public void sendFinishMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(3, null));
    }

    @Override
    public void sendRetryMessage(int n) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(5, new Object[]{n}));
    }

    @Override
    public void sendPauseMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(7, null));
    }

    @Override
    public void sendProgressMessage(long l, long l2) {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(4, new Object[]{l, l2}));
    }

    @Override
    public final void sendCancelMessage() {
        HttpCallbackImpl httpCallbackImpl = this;
        httpCallbackImpl.b(httpCallbackImpl.a(6, null));
    }

    protected final void a(Runnable runnable) {
        if (this.getUseSyncMode() || this.a == null) {
            runnable.run();
            return;
        }
        this.a.post(runnable);
    }

    private Message a(int n, Object object) {
        return Message.obtain((Handler)this.a, (int)n, (Object)object);
    }

    private void b(Message message) {
        if (this.getUseSyncMode() || this.a == null) {
            this.a(message);
            return;
        }
        if (!Thread.currentThread().isInterrupted()) {
            CheckUtil.asserts(this.a != null, "handler should not be null!");
            this.a.sendMessage(message);
        }
    }

    protected final void a(Message objectArray) {
        block27: {
            try {
                switch (objectArray.what) {
                    case 0: {
                        objectArray = (Object[])objectArray.obj;
                        if (objectArray != null && objectArray.length >= 2) {
                            if (objectArray.length >= 3) {
                                if (objectArray[2] instanceof String) {
                                    this.onSuccess((Integer)objectArray[0], (byte[])objectArray[1], (String)objectArray[2]);
                                } else {
                                    if (!(objectArray[2] instanceof Map)) break;
                                    this.onResponseHeader((Map)objectArray[2]);
                                    this.onSuccess((Integer)objectArray[0], (byte[])objectArray[1]);
                                }
                            } else {
                                this.onSuccess((Integer)objectArray[0], (byte[])objectArray[1]);
                            }
                        } else {
                            Console.log.e("HttpCallbackImpl", "SUCCESS_MESSAGE didn't got enough params");
                        }
                        break block27;
                    }
                    case 1: {
                        objectArray = (Object[])objectArray.obj;
                        if (objectArray != null && objectArray.length >= 3) {
                            if (objectArray.length >= 4 && objectArray[3] instanceof Map) {
                                this.onResponseHeader((Map)objectArray[3]);
                            }
                            this.onFailure((Integer)objectArray[0], (byte[])objectArray[1], (Throwable)objectArray[2]);
                        } else {
                            Console.log.e("HttpCallbackImpl", "FAILURE_MESSAGE didn't got enough params");
                        }
                        break block27;
                    }
                    case 2: {
                        this.onStart();
                        break block27;
                    }
                    case 3: {
                        this.onFinish();
                        break block27;
                    }
                    case 7: {
                        this.onPause();
                        break block27;
                    }
                    case 4: {
                        objectArray = (Object[])objectArray.obj;
                        if (objectArray != null && objectArray.length >= 2) {
                            try {
                                this.onProgress((Long)objectArray[0], (Long)objectArray[1]);
                            }
                            catch (Throwable throwable) {
                                Console.log.e("HttpCallbackImpl", "custom onProgress contains an error", throwable);
                            }
                        } else {
                            Console.log.e("HttpCallbackImpl", "PROGRESS_MESSAGE didn't got enough params");
                        }
                        break block27;
                    }
                    case 5: {
                        objectArray = (Object[])objectArray.obj;
                        if (objectArray != null && objectArray.length == 1) {
                            this.onRetry((Integer)objectArray[0]);
                        } else {
                            Console.log.e("HttpCallbackImpl", "RETRY_MESSAGE didn't get enough params");
                        }
                        break block27;
                    }
                    case 6: {
                        this.onCancel();
                        break block27;
                    }
                    default: {
                        Console.log.e("HttpCallbackImpl", "UnKnown message");
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                this.onUserException(throwable);
            }
        }
    }

    @Override
    public void sendResponseMessage(int n, byte[] byArray) {
        if (!Thread.currentThread().isInterrupted()) {
            if (n >= 300) {
                this.sendFailureMessage(n, byArray, new IOException());
                return;
            }
            this.sendSuccessMessage(n, byArray);
        }
    }

    @Override
    public void sendResponseMessage(int n, byte[] byArray, String string) {
        if (!Thread.currentThread().isInterrupted()) {
            if (n >= 300) {
                this.sendFailureMessage(n, byArray, new IOException());
                return;
            }
            this.sendSuccessMessage(n, byArray, string);
        }
    }

    @Override
    public void sendResponseMessage(int n, byte[] byArray, Map<String, List<String>> map) {
        if (!Thread.currentThread().isInterrupted()) {
            if (n >= 300) {
                this.sendFailureMessage(n, byArray, new IOException(), map);
                return;
            }
            this.sendSuccessMessage(n, byArray, map);
        }
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onCancel() {
        Console.log.d("HttpCallbackImpl", "Request got cancelled");
    }

    public void onRetry(int n) {
        Console.log.d("HttpCallbackImpl", String.format("Request retry no. %d", n));
    }

    public void onProgress(long l, long l2) {
        Console.log.v("HttpCallbackImpl", String.format("Progress %d from %d (%2.0f%%)", l, l2, l2 > 0L ? (double)l / (double)l2 * 100.0 : -1.0));
    }

    public void onPause() {
        Console.log.d("HttpCallbackImpl", "Request got onPaused");
    }

    public void onUserException(Throwable throwable) {
        Console.log.e("HttpCallbackImpl", "User-space exception detected!", throwable);
        throw new RuntimeException(throwable);
    }

    static final class a
    extends Handler {
        private final HttpCallbackImpl a;

        a(HttpCallbackImpl httpCallbackImpl, Looper looper) {
            super(looper);
            this.a = httpCallbackImpl;
        }

        public final void handleMessage(Message message) {
            this.a.a(message);
        }
    }
}

