/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.util;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.transsion.core.utils.Commutil;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String INDIVIDUAL_DIR_NAME = "ad-images";
    private static final String OFFLINE_CACHE = "offline_cache";
    private static final String NORMAL_CACHE = "hisavana_net_cache";
    private static final String TAG = "StorageUtils";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    public static File getCacheDirectory(Context object, boolean bl) {
        String string;
        File file = null;
        try {
            string = Environment.getExternalStorageState();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            string = "";
        }
        if (bl && "mounted".equals(string) && (file = object.getExternalFilesDir(null)) != null && file.exists() && !(file = new File(file.getPath() + File.separator + NORMAL_CACHE)).exists() && !file.mkdir()) {
            Log.w((String)TAG, (String)"can't create cache file");
        }
        if (!(file != null && (file.exists() || file.mkdirs()) || (file = Commutil.getExternalCacheDir((Context)object.getApplicationContext())) != null && file.exists())) {
            file = object.getFilesDir();
        }
        if (file == null || !file.exists()) {
            file = object.getCacheDir();
        }
        if (file == null) {
            object = "/data/data/" + object.getPackageName() + File.separator + NORMAL_CACHE;
            Log.w((String)TAG, (String)("Can't define system cache directory! '%s' will be used." + (String)object));
            file = new File((String)object);
        }
        return file;
    }

    public static File getOfflineCacheDirectory(Context context, boolean bl) {
        boolean bl2;
        String string;
        boolean bl3;
        String string2;
        String string3;
        File file = null;
        try {
            string3 = Environment.getExternalStorageState();
        }
        catch (NullPointerException nullPointerException) {
            string3 = "";
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            string3 = "";
        }
        if (bl && "mounted".equals(string3) && (file = context.getExternalFilesDir(null)) != null && !(file = new File(string2 = file.getPath() + File.separator + OFFLINE_CACHE)).exists() && !(bl3 = file.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,storage cache is not ready");
        }
        if (file == null && !(file = new File(string = "/data/data/" + context.getPackageName() + File.separator + OFFLINE_CACHE)).exists() && !(bl2 = file.mkdir())) {
            Log.e((String)TAG, (String)"getOfflineCacheDirectory,app cache path is not ready");
        }
        return file;
    }

    public static File getIndividualCacheDirectory(Context context) {
        return StorageUtils.getIndividualCacheDirectory(context, INDIVIDUAL_DIR_NAME);
    }

    public static File getIndividualCacheDirectory(Context object, String object2) {
        object2 = new File((File)(object = StorageUtils.getCacheDirectory(object)), (String)object2);
        if (!((File)object2).exists() && !((File)object2).mkdir()) {
            object2 = object;
        }
        return object2;
    }

    public static File getOwnCacheDirectory(Context context, String string) {
        File file = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            file = new File(Environment.getExternalStorageDirectory(), string);
        }
        if (file == null || !file.exists() && !file.mkdirs()) {
            file = context.getCacheDir();
        }
        return file;
    }

    public static File getOwnCacheDirectory(Context context, String string, boolean bl) {
        File file = null;
        if (bl && "mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            file = new File(Environment.getExternalStorageDirectory(), string);
        }
        if (!(file != null && (file.exists() || file.mkdirs()) || (file = Commutil.getExternalCacheDir((Context)context.getApplicationContext())) != null && file.exists())) {
            file = context.getCacheDir();
        }
        return file;
    }

    public static File getOwnCacheDirectory(Context context) {
        File file = context.getFilesDir();
        if (file == null || !file.exists()) {
            file = context.getCacheDir();
        }
        return file;
    }

    private static File getExternalCacheDir(Context object) {
        File file = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        object = new File(new File(new File(file, object.getPackageName()), "files"), "images");
        if (!((File)object).exists()) {
            if (!((File)object).mkdirs()) {
                Log.w((String)"error", (String)"Unable to create external cache directory");
                return null;
            }
            try {
                new File((File)object, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                Log.i((String)"error", (String)"Can't create \".nomedia\" file in application external cache directory");
            }
        }
        return object;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        int n = context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION);
        return n == 0;
    }
}

