/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteBufferUtil {
    private static final int BUFFER_SIZE = 16384;
    private static final AtomicReference<byte[]> BUFFER_REF = new AtomicReference();

    private ByteBufferUtil() {
    }

    public static ByteBuffer fromFile(File comparable) throws IOException {
        RandomAccessFile randomAccessFile;
        block12: {
            randomAccessFile = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                randomAccessFile = new RandomAccessFile((File)comparable, "r");
                abstractInterruptibleChannel = randomAccessFile.getChannel();
                comparable = ((FileChannel)abstractInterruptibleChannel).map(FileChannel.MapMode.READ_ONLY, 0L, comparable.length()).load();
                if (abstractInterruptibleChannel == null) break block12;
            }
            catch (Throwable throwable) {
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException) {}
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {}
        return comparable;
    }

    public static void toFile(ByteBuffer byteBuffer, File file) throws IOException {
        RandomAccessFile randomAccessFile;
        block12: {
            randomAccessFile = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                abstractInterruptibleChannel = randomAccessFile.getChannel();
                ((FileChannel)abstractInterruptibleChannel).write(byteBuffer);
                ((FileChannel)abstractInterruptibleChannel).force(false);
                abstractInterruptibleChannel.close();
                randomAccessFile.close();
                if (abstractInterruptibleChannel == null) break block12;
            }
            catch (Throwable throwable) {
                if (abstractInterruptibleChannel != null) {
                    try {
                        abstractInterruptibleChannel.close();
                    }
                    catch (IOException iOException) {}
                }
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                abstractInterruptibleChannel.close();
            }
            catch (IOException iOException) {}
        }
        try {
            randomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void toStream(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        Object object = ByteBufferUtil.getSafeArray(byteBuffer);
        if (object != null) {
            outputStream.write(((b)object).c, ((b)object).a, ((b)object).a + ((b)object).b);
            return;
        }
        byte[] byArray = BUFFER_REF.getAndSet(null);
        object = byArray;
        if (byArray == null) {
            object = new byte[16384];
        }
        while (byteBuffer.remaining() > 0) {
            int n = Math.min(byteBuffer.remaining(), ((Object)object).length);
            byteBuffer.get((byte[])object, 0, n);
            outputStream.write((byte[])object, 0, n);
        }
        BUFFER_REF.set((byte[])object);
    }

    public static byte[] toBytes(ByteBuffer object) {
        Object object2 = ByteBufferUtil.getSafeArray((ByteBuffer)object);
        if (object2 != null && ((b)object2).a == 0 && ((b)object2).b == ((b)object2).c.length) {
            object = ((ByteBuffer)object).array();
        } else {
            object2 = ((ByteBuffer)object).asReadOnlyBuffer();
            object = new byte[((Buffer)object2).limit()];
            ((ByteBuffer)object2).position(0);
            ((ByteBuffer)object2).get((byte[])object);
        }
        return object;
    }

    public static InputStream toStream(ByteBuffer byteBuffer) {
        return new a(byteBuffer);
    }

    public static InputStream lengthToStream(InputStream inputStream, int n) {
        return new ContentLengthInputStream(inputStream, n);
    }

    public static ByteBuffer fromStream(InputStream object) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16384);
        byte[] byArray = BUFFER_REF.getAndSet(null);
        if (byArray == null) {
            byArray = new byte[16384];
        }
        while ((n = ((InputStream)object).read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        BUFFER_REF.set(byArray);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        object = byArray2;
        return (ByteBuffer)ByteBuffer.allocateDirect(byArray2.length).put((byte[])object).position(0);
    }

    private static b getSafeArray(ByteBuffer byteBuffer) {
        if (!byteBuffer.isReadOnly() && byteBuffer.hasArray()) {
            return new b(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        }
        return null;
    }

    public static class ContentLengthInputStream
    extends InputStream {
        private final InputStream stream;
        private final int length;

        public ContentLengthInputStream(InputStream inputStream, int n) {
            this.stream = inputStream;
            this.length = n;
        }

        @Override
        public int available() {
            return this.length;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public synchronized void mark(int n) {
            this.stream.mark(n);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.stream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.stream.read(byArray, n, n2);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long l) throws IOException {
            return this.stream.skip(l);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }

    static final class a
    extends InputStream {
        private final ByteBuffer a;
        private int b = -1;

        public a(ByteBuffer byteBuffer) {
            this.a = byteBuffer;
        }

        @Override
        public final int available() throws IOException {
            return this.a.remaining();
        }

        @Override
        public final int read() throws IOException {
            if (!this.a.hasRemaining()) {
                return -1;
            }
            return this.a.get();
        }

        @Override
        public final synchronized void mark(int n) {
            this.b = this.a.position();
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.a.hasRemaining()) {
                return -1;
            }
            n2 = Math.min(n2, this.available());
            this.a.get(byArray, n, n2);
            return n2;
        }

        @Override
        public final synchronized void reset() throws IOException {
            if (this.b == -1) {
                throw new IOException("Cannot reset to unset mark position");
            }
            this.a.position(this.b);
        }

        @Override
        public final long skip(long l) throws IOException {
            if (!this.a.hasRemaining()) {
                return -1L;
            }
            long l2 = Math.min(l, (long)this.available());
            this.a.position((int)((long)this.a.position() + l2));
            return l2;
        }
    }

    static final class b {
        private final int a;
        private final int b;
        private final byte[] c;

        public b(byte[] byArray, int n, int n2) {
            this.c = byArray;
            this.a = n;
            this.b = n2;
        }
    }
}

