/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.util;

import android.text.TextUtils;
import com.cloud.hisavana.http.log.Console;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class IOUtil {
    private static final String UTF_CODE = "UTF-8";

    private IOUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Throwable throwable) {
                Console.log.d("error", throwable.getMessage());
            }
        }
    }

    public static byte[] readBytes(InputStream object) throws IOException {
        if (!(object instanceof BufferedInputStream)) {
            object = new BufferedInputStream((InputStream)object);
        }
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)object).read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            object = byteArrayOutputStream.toByteArray();
            return object;
        }
        finally {
            IOUtil.closeQuietly(byteArrayOutputStream);
        }
    }

    public static byte[] readBytes(InputStream inputStream, long l, int n) throws IOException {
        if (l > 0L) {
            long l2;
            while (l > 0L && (l2 = inputStream.skip(l)) > 0L) {
                l -= l2;
            }
        }
        byte[] byArray = new byte[n];
        for (int i2 = 0; i2 < n; ++i2) {
            byArray[i2] = (byte)inputStream.read();
        }
        return byArray;
    }

    public static String readStr(InputStream inputStream) throws IOException {
        return IOUtil.readStr(inputStream, UTF_CODE);
    }

    public static String readStr(InputStream closeable, String charSequence) throws IOException {
        int n;
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            charSequence = UTF_CODE;
        }
        if (!(closeable instanceof BufferedInputStream)) {
            closeable = new BufferedInputStream((InputStream)closeable);
        }
        closeable = new InputStreamReader((InputStream)closeable, (String)charSequence);
        charSequence = new StringBuilder();
        char[] cArray = new char[1024];
        while ((n = ((Reader)closeable).read(cArray)) >= 0) {
            ((StringBuilder)charSequence).append(cArray, 0, n);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static void writeStr(OutputStream outputStream, String string) throws IOException {
        IOUtil.writeStr(outputStream, string, UTF_CODE);
    }

    public static void writeStr(OutputStream closeable, String string, String string2) throws IOException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = UTF_CODE;
        }
        closeable = new OutputStreamWriter((OutputStream)closeable, string2);
        ((Writer)closeable).write(string);
        ((Writer)closeable).flush();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(outputStream instanceof BufferedOutputStream)) {
            outputStream = new BufferedOutputStream(outputStream);
        }
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }
}

