/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageUtil {
    public static byte[] bitmapToByte(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Bitmap byteToBitmap(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        return ((BitmapDrawable)drawable).getBitmap();
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        return new BitmapDrawable(bitmap);
    }

    public static byte[] drawableToByte(Drawable drawable) {
        return ImageUtil.bitmapToByte(ImageUtil.drawableToBitmap(drawable));
    }

    public static Drawable byteToDrawable(byte[] byArray) {
        return ImageUtil.bitmapToDrawable(ImageUtil.byteToBitmap(byArray));
    }

    public static Bitmap scaleImageTo(Bitmap bitmap, int n, int n2) {
        return ImageUtil.scaleImage(bitmap, (float)n / (float)bitmap.getWidth(), (float)n2 / (float)bitmap.getHeight());
    }

    public static Bitmap scaleImage(Bitmap bitmap, float f2, float f3) {
        if (bitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(f2, f3);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static void closeInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred. ", iOException);
        }
    }
}

