/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.http.util;

public final class Pools {
    private Pools() {
    }

    public static class SynchronizedPool<T>
    extends SimplePool<T> {
        private final Object mLock = new Object();

        public SynchronizedPool(int n) {
            super(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T acquire() {
            Object object = this.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(T t) {
            Object object = this.mLock;
            synchronized (object) {
                return super.release(t);
            }
        }
    }

    public static class SimplePool<T>
    implements Pool<T> {
        private final Object[] mPool;
        private int mPoolSize;

        public SimplePool(int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[n];
        }

        @Override
        public T acquire() {
            if (this.mPoolSize > 0) {
                int n = this.mPoolSize - 1;
                Object object = this.mPool[n];
                this.mPool[n] = null;
                --this.mPoolSize;
                return (T)object;
            }
            return null;
        }

        @Override
        public boolean release(T t) {
            if (this.isInPool(t)) {
                throw new IllegalStateException("Already in the pool!");
            }
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = t;
                ++this.mPoolSize;
                return true;
            }
            return false;
        }

        private boolean isInPool(T t) {
            for (int i2 = 0; i2 < this.mPoolSize; ++i2) {
                if (this.mPool[i2] != t) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Pool<T> {
        public T acquire();

        public boolean release(T var1);
    }
}

