/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.adcolony.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.adcolony.sdk.AdColony;
import com.adcolony.sdk.AdColonyAdOptions;
import com.adcolony.sdk.AdColonyInterstitial;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyReward;
import com.adcolony.sdk.AdColonyRewardListener;
import com.adcolony.sdk.AdColonyZone;
import com.hisavana.adcolony.check.ExistsCheck;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdColonyVideo
extends BaseVideo {
    private AdColonyAdOptions a;
    private AdColonyInterstitial b;
    private AdColonyInterstitialListener c;

    public AdColonyVideo(Context context, Network network) {
        super(context, network);
    }

    protected void initVideo() {
        if (this.mNetwork == null) {
            this.adFailedToLoad(new TAdErrorCode(1, "adColony init fail"));
            return;
        }
        if (!ExistsCheck.initAdColony(this.mNetwork.getApplicationId())) {
            AdLogUtil.Log().e("AdColonyVideo", "onBannerLoad adColony init fail");
            this.adFailedToLoad(new TAdErrorCode(1, "adColony init fail"));
            return;
        }
        AdLogUtil.Log().d("AdColonyVideo", "initVideo ");
        this.a = new AdColonyAdOptions();
        AdColony.setRewardListener((AdColonyRewardListener)new AdColonyRewardListener(){

            public void onReward(@NonNull AdColonyReward adColonyReward) {
                AdLogUtil.Log().d("AdColonyVideo", "onReward ");
                AdColonyVideo.this.onReward();
            }
        });
        this.c = new AdColonyInterstitialListener(){

            public void onRequestFilled(AdColonyInterstitial adColonyInterstitial) {
                AdLogUtil.Log().d("AdColonyVideo", "onRequestFilled ");
                AdColonyVideo.this.b = adColonyInterstitial;
                AdColonyVideo.this.adLoaded();
            }

            public void onRequestNotFilled(AdColonyZone adColonyZone) {
                AdLogUtil.Log().d("AdColonyVideo", "onRequestNotFilled ");
                AdColonyVideo.this.adFailedToLoad(new TAdErrorCode(1, "Adcolony video load wrong"));
            }

            public void onOpened(AdColonyInterstitial adColonyInterstitial) {
                AdLogUtil.Log().d("AdColonyVideo", "onOpened ");
                AdColonyVideo.this.adImpression();
            }

            public void onExpiring(AdColonyInterstitial adColonyInterstitial) {
                AdLogUtil.Log().d("AdColonyVideo", "onExpiring ");
            }

            public void onClicked(AdColonyInterstitial adColonyInterstitial) {
                AdLogUtil.Log().d("AdColonyVideo", "onClicked ");
                super.onClicked(adColonyInterstitial);
                AdColonyVideo.this.adClicked();
            }

            public void onClosed(AdColonyInterstitial adColonyInterstitial) {
                AdLogUtil.Log().d("AdColonyVideo", "onClosed ");
                super.onClosed(adColonyInterstitial);
                AdColonyVideo.this.adClosed();
            }
        };
    }

    protected void onVideoStartLoad() {
        AdLogUtil.Log().d("AdColonyVideo", "onVideoStartLoad placementId " + this.getPlacementId());
        try {
            AdColony.requestInterstitial((String)this.getPlacementId(), (AdColonyInterstitialListener)this.c, (AdColonyAdOptions)this.a);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("AdColonyVideo", "onVideoStartLoad " + Log.getStackTraceString((Throwable)exception));
            this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
        }
    }

    protected void onVideoShow(Activity activity) {
        if (this.b != null && !this.b.isExpired() && activity != null) {
            this.b.show();
        }
    }

    public boolean isLoaded() {
        return this.b != null && !this.b.isExpired();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.b != null) {
            this.b.destroy();
            this.b = null;
        }
    }
}

