/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;

public class AdmobSplash
extends BaseSplash {
    private static final String TAG = "AdmobSplash";
    private static String AD_UNIT_ID = "";
    public AppOpenAd appOpenAd = null;
    private static boolean isShowingAd = false;
    public AppOpenAd.AppOpenAdLoadCallback loadCallback;
    private Activity currentActivity;

    public AdmobSplash(Context context, Network network) {
        super(context, network);
        AdLogUtil.Log().d(TAG, "placemen id:=" + network.codeSeatId);
    }

    public void fetchAd() {
        if (this.isAdAvailable()) {
            return;
        }
        this.loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void a(AppOpenAd appOpenAd) {
                AdmobSplash.this.appOpenAd = appOpenAd;
                AdmobSplash.this.adLoaded();
                AdLogUtil.Log().d(AdmobSplash.TAG, "admob appOpenAd onAdLoaded");
                AdmobSplash.this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        AdmobSplash.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview show fail:" + adError.getMessage());
                    }

                    public void onAdShowedFullScreenContent() {
                        super.onAdShowedFullScreenContent();
                        AdmobSplash.this.adImpression();
                        isShowingAd = true;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdShow");
                    }

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        AdmobSplash.this.onSkipClick();
                        AdmobSplash.this.appOpenAd = null;
                        isShowingAd = false;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdClicked");
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                AdmobSplash.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                AdLogUtil.Log().e(AdmobSplash.TAG, "admob splashview onError:" + loadAdError.toString());
            }

            public /* synthetic */ void onAdLoaded(Object object) {
                this.a((AppOpenAd)object);
            }
        };
        AdRequest adRequest = this.getAdRequest();
        if (this.mContext != null && this.mContext.get() != null && !TextUtils.isEmpty((CharSequence)this.mNetwork.codeSeatId) && adRequest != null) {
            try {
                AppOpenAd.load((Context)((Context)this.mContext.get()).getApplicationContext(), (String)this.mNetwork.codeSeatId, (AdRequest)adRequest, (int)1, (AppOpenAd.AppOpenAdLoadCallback)this.loadCallback);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            try {
                this.appOpenAd.show(this.currentActivity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public AdRequest getAdRequest() {
        return new AdRequest.Builder().build();
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null;
    }

    protected void onSplashStartLoad() {
    }

    protected View getSplash() {
        AdLogUtil.Log().d(TAG, "admob splashview load mPlacementId:" + this.mNetwork.codeSeatId);
        this.fetchAd();
        AdLogUtil.Log().d(TAG, "admob splashview load mPlacementId" + this.mNetwork.codeSeatId + ",context is :" + this.mContext);
        if (this.mContext != null && this.mContext.get() != null) {
            return new View(((Context)this.mContext.get()).getApplicationContext());
        }
        return null;
    }

    protected void onSplashShow() {
        this.showAdIfAvailable();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.appOpenAd != null) {
            this.appOpenAd = null;
        }
        if (this.loadCallback != null) {
            this.loadCallback = null;
        }
    }
}

