/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.TAdErrorCode;

public class AdmobVideo
extends BaseVideo {
    private RewardedAd p;
    private RewardedAdLoadCallback q;

    public boolean isLoaded() {
        return this.p != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.p != null) {
            this.p = null;
            AdLogUtil.Log().d("video_log", "AdmobVideo --> destroy");
        }
        if (this.q != null) {
            this.q = null;
        }
    }

    protected void initVideo() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.q = new RewardedAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    AdmobVideo.this.p = null;
                    AdLogUtil.Log().e("video_log", "AdmobVideo --> ad load failed, error :" + loadAdError.toString());
                    AdmobVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void a(@NonNull RewardedAd rewardedAd) {
                    AdmobVideo.this.p = rewardedAd;
                    AdLogUtil.Log().d("video_log", "AdmobVideo --> Video Ad was loaded.");
                    AdmobVideo.this.adLoaded();
                }

                public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                    this.a((RewardedAd)object);
                }
            };
        }
    }

    protected void onVideoStartLoad() {
        if (null != this.q && null != this.mContext && null != this.mContext.get()) {
            try {
                RewardedAd.load((Context)((Context)this.mContext.get()).getApplicationContext(), (String)this.mNetwork.codeSeatId, (AdRequest)PlatformUtil.getAdRequest(), (RewardedAdLoadCallback)this.q);
            }
            catch (Exception exception) {
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                exception.printStackTrace();
                AdLogUtil.Log().e("video_log", "AdmobVideo --> RewardedAd.load exception " + Log.getStackTraceString((Throwable)exception));
            }
        }
        if (null != this.mNetwork) {
            AdLogUtil.Log().d("video_log", "AdmobVideo --> admob AdmobVideo load mPlacementId:" + this.mNetwork.codeSeatId);
        }
    }

    protected void onVideoShow() {
        if (null == this.mContext || null == this.mContext.get()) {
            AdLogUtil.Log().e("video_log", "AdmobVideo --> onVideoShow null == mContext.get() || null == mContext");
            return;
        }
        if (this.p != null) {
            try {
                AdLogUtil.Log().d("video_log", "AdmobVideo --> onVideoShow.");
                this.p.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("video_log", "AdmobVideo --> Ad was shown.");
                        AdmobVideo.this.adImpression();
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().e("video_log", "AdmobVideo --> Ad failed to show.");
                        AdmobVideo.this.p = null;
                        AdmobVideo.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobVideo.this.p = null;
                        AdLogUtil.Log().d("video_log", "AdmobVideo --> video is adClosed");
                        AdmobVideo.this.adClosed();
                    }
                });
                Activity activity = (Activity)this.mContext.get();
                AdLogUtil.Log().e("video_log", " activity is finish =" + activity.isFinishing());
                this.p.show(activity, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        AdLogUtil.Log().d("video_log", "AdmobVideo --> The user earned the reward.");
                        int n = rewardItem.getAmount();
                        String string = rewardItem.getType();
                        AdmobVideo.this.onReward();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                AdLogUtil.Log().e("video_log", "AdmobVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception));
            }
        } else {
            AdLogUtil.Log().e("video_log", "AdmobVideo --> The rewarded ad wasn't ready yet.");
        }
    }
}

