/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.holder;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.hisavana.admoblibrary.R;
import com.hisavana.common.base.BaseNativeViewHolder;
import com.hisavana.common.bean.AdSourceConfig;
import com.hisavana.common.bean.TAdNativeInfo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NativeAdViewHolder
extends BaseNativeViewHolder {
    private NativeAdView s;
    private final LinkedHashMap<String, NativeAdView> t = new LinkedHashMap();

    public View getContainer(TAdNativeInfo tAdNativeInfo, ViewGroup viewGroup) {
        this.s = this.t.get(tAdNativeInfo.getAdId());
        if (this.s == null) {
            this.s = (NativeAdView)LayoutInflater.from((Context)viewGroup.getContext().getApplicationContext()).inflate(R.layout.google_native_app_unified_ad_view, viewGroup, false);
        }
        return this.s;
    }

    public void destroy() {
        super.destroy();
        if (this.t.size() > 0) {
            Iterator<Map.Entry<String, NativeAdView>> iterator = this.t.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Map.Entry<String, NativeAdView> entry = iterator.next();
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().removeAllViews();
                entry.getValue().destroy();
            }
        }
        this.t.clear();
        if (this.s != null) {
            this.s.removeAllViews();
            this.s.destroy();
            this.s = null;
        }
    }

    public void addContentView(View view) {
        if (this.s != null) {
            this.s.removeAllViews();
            this.s.addView(view);
        }
    }

    public void setBodyView(View view) {
        if (this.s != null) {
            this.s.setBodyView(view);
        }
    }

    public void setCallToActionView(View view) {
        if (this.s != null) {
            this.s.setCallToActionView(view);
        }
    }

    public void setHeadlineView(View view) {
        if (this.s != null) {
            this.s.setHeadlineView(view);
        }
    }

    public void setMediaView(View view) {
        if (this.s != null) {
            if (view instanceof MediaView) {
                this.s.setMediaView((MediaView)view);
            } else {
                this.s.setImageView(view);
            }
        }
    }

    public void setNativeAd(TAdNativeInfo tAdNativeInfo) {
        if (this.t.containsValue(this.s) || this.e()) {
            AdLogUtil.Log().w("NativeAdViewHolder", "----> admob container has called setNativeAd() before.");
            return;
        }
        try {
            if (tAdNativeInfo == null) {
                return;
            }
            Object object = tAdNativeInfo.getNativeAdWrapper().getNativeAd();
            if (this.s != null && object instanceof NativeAd) {
                if (this.s.getMediaView() != null) {
                    this.s.getMediaView().setMediaContent(((NativeAd)object).getMediaContent());
                }
                this.s.setNativeAd((NativeAd)object);
                this.a(tAdNativeInfo.getAdId(), this.s);
                AdLogUtil.Log().w("NativeAdViewHolder", "----> call setNativeAd()");
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    private boolean e() {
        return this.t.size() >= 5;
    }

    private void a(String string, NativeAdView nativeAdView) {
        try {
            this.t.put(string, nativeAdView);
            if (this.t.size() > 5) {
                AdLogUtil.Log().w("NativeAdViewHolder", "admob container holders exceed the max threshold");
                Map.Entry<String, NativeAdView> entry = this.t.entrySet().iterator().next();
                if (entry != null) {
                    this.t.remove(entry.getKey());
                }
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    public void setIconView(View view) {
        if (this.s != null) {
            this.s.setIconView(view);
        }
    }

    protected View createMediaView(Context context, TAdNativeInfo tAdNativeInfo) {
        List list;
        if (!(AdSourceConfig.isUseMediaView || (list = tAdNativeInfo.getImageList()) == null || list.isEmpty() || ((TAdNativeInfo.Image)list.get(0)).getDrawable() == null && TextUtils.isEmpty((CharSequence)((TAdNativeInfo.Image)list.get(0)).getUrl()))) {
            return new ImageView(context);
        }
        return new MediaView(context);
    }
}

