/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.holder;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.hisavana.admoblibrary.R;
import com.hisavana.common.base.BaseNativeViewHolder;
import com.hisavana.common.bean.AdSourceConfig;
import com.hisavana.common.bean.TAdNativeInfo;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NativeAdViewHolder
extends BaseNativeViewHolder {
    private NativeAdView r;
    private final LinkedHashMap<String, NativeAdView> s = new LinkedHashMap();

    public View getContainer(TAdNativeInfo tAdNativeInfo, ViewGroup viewGroup) {
        this.r = this.s.get(tAdNativeInfo.getAdId());
        if (this.r == null) {
            this.r = (NativeAdView)LayoutInflater.from((Context)viewGroup.getContext().getApplicationContext()).inflate(R.layout.google_native_app_unified_ad_view, viewGroup, false);
        }
        return this.r;
    }

    public void destroy() {
        super.destroy();
        if (this.s.size() > 0) {
            Iterator<Map.Entry<String, NativeAdView>> iterator = this.s.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Map.Entry<String, NativeAdView> entry = iterator.next();
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().removeAllViews();
                entry.getValue().destroy();
            }
        }
        this.s.clear();
        if (this.r != null) {
            this.r.removeAllViews();
            this.r.destroy();
            this.r = null;
        }
    }

    public void addContentView(View view) {
        if (this.r != null) {
            this.r.removeAllViews();
            this.r.addView(view);
        }
    }

    public void setBodyView(View view) {
        if (this.r != null) {
            this.r.setBodyView(view);
        }
    }

    public void setCallToActionView(View view) {
        if (this.r != null) {
            this.r.setCallToActionView(view);
        }
    }

    public void setHeadlineView(View view) {
        if (this.r != null) {
            this.r.setHeadlineView(view);
        }
    }

    public void setMediaView(View view) {
        if (this.r != null) {
            if (view instanceof MediaView) {
                this.r.setMediaView((MediaView)view);
            } else {
                this.r.setImageView(view);
            }
        }
    }

    public void setNativeAd(TAdNativeInfo tAdNativeInfo) {
        if (this.s.containsValue(this.r)) {
            AdLogUtil.Log().w("NativeAdViewHolder", "----> admob container has called setNativeAd() before.");
            return;
        }
        try {
            if (tAdNativeInfo == null) {
                return;
            }
            Object object = tAdNativeInfo.getNativeAdWrapper().getNativeAd();
            if (this.r != null && object instanceof NativeAd) {
                if (this.r.getMediaView() != null) {
                    this.r.getMediaView().setMediaContent(((NativeAd)object).getMediaContent());
                }
                this.r.setNativeAd((NativeAd)object);
                this.a(tAdNativeInfo.getAdId(), this.r);
                AdLogUtil.Log().w("NativeAdViewHolder", "----> call setNativeAd()");
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    private void a(String string, NativeAdView nativeAdView) {
        try {
            this.s.put(string, nativeAdView);
            if (this.s.size() > 5) {
                AdLogUtil.Log().w("NativeAdViewHolder", "admob container holders exceed the max threshold");
                Map.Entry<String, NativeAdView> entry = this.s.entrySet().iterator().next();
                if (entry != null) {
                    this.s.remove(entry.getKey());
                }
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    public void setIconView(View view) {
        if (this.r != null) {
            this.r.setIconView(view);
        }
    }

    protected View createMediaView(Context context, TAdNativeInfo tAdNativeInfo) {
        List list;
        if (!(AdSourceConfig.isUseMediaView || (list = tAdNativeInfo.getImageList()) == null || list.isEmpty() || ((TAdNativeInfo.Image)list.get(0)).getDrawable() == null && TextUtils.isEmpty((CharSequence)((TAdNativeInfo.Image)list.get(0)).getUrl()))) {
            return new ImageView(context);
        }
        return new MediaView(context);
    }
}

