/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;

public class AdmobVideo
extends BaseVideo {
    private RewardedAd o;
    private RewardedAdLoadCallback p;

    public AdmobVideo(Context context, Network network) {
        super(context, network);
        AdLogUtil.Log().d("video", "AdmobVideo --> placemen id:=" + (network != null ? network.codeSeatId : ""));
    }

    public boolean isLoaded() {
        return this.o != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.o != null) {
            this.o = null;
            AdLogUtil.Log().d("video", "AdmobVideo --> destroy");
        }
        if (this.p != null) {
            this.p = null;
        }
    }

    protected void initVideo() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.p = new RewardedAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    AdmobVideo.this.o = null;
                    AdLogUtil.Log().w("video", "AdmobVideo --> ad load failed, error :" + loadAdError.toString());
                    AdmobVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void a(@NonNull RewardedAd rewardedAd) {
                    AdmobVideo.this.o = rewardedAd;
                    AdLogUtil.Log().d("video", "AdmobVideo --> Video Ad was loaded.");
                    AdmobVideo.this.adLoaded();
                }

                public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                    this.a((RewardedAd)object);
                }
            };
        }
    }

    protected void onVideoStartLoad() {
        if (null != this.p && null != this.mContext && null != this.mContext.get()) {
            try {
                RewardedAd.load((Context)((Context)this.mContext.get()).getApplicationContext(), (String)this.mNetwork.codeSeatId, (AdRequest)PlatformUtil.getAdRequest(), (RewardedAdLoadCallback)this.p);
            }
            catch (Exception exception) {
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                exception.printStackTrace();
                AdLogUtil.Log().e("video", "AdmobVideo --> RewardedAd.load exception " + Log.getStackTraceString((Throwable)exception));
            }
        }
        if (null != this.mNetwork) {
            AdLogUtil.Log().d("video", "AdmobVideo --> admob AdmobVideo load mPlacementId:" + this.mNetwork.codeSeatId);
        }
    }

    protected void onVideoShow() {
        if (null == this.mContext || null == this.mContext.get()) {
            AdLogUtil.Log().w("video", "AdmobVideo --> onVideoShow null == mContext.get() || null == mContext");
            return;
        }
        if (this.o != null) {
            try {
                AdLogUtil.Log().d("video", "AdmobVideo --> onVideoShow.");
                this.o.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("video", "AdmobVideo --> Ad was shown.");
                        AdmobVideo.this.adImpression();
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().w("video", "AdmobVideo --> Ad failed to show.");
                        AdmobVideo.this.o = null;
                        if (null != adError) {
                            AdmobVideo.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobVideo.this.o = null;
                        AdLogUtil.Log().d("video", "AdmobVideo --> video is adClosed");
                        AdmobVideo.this.adClosed();
                    }
                });
                if (this.mContext.get() instanceof Activity) {
                    Activity activity = (Activity)this.mContext.get();
                    AdLogUtil.Log().d("video", " activity is finish =" + activity.isFinishing());
                    this.o.show(activity, new OnUserEarnedRewardListener(){

                        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                            if (rewardItem == null) {
                                return;
                            }
                            AdLogUtil.Log().d("video", "AdmobVideo --> The user earned the reward.");
                            int n = rewardItem.getAmount();
                            String string = rewardItem.getType();
                            AdmobVideo.this.onReward();
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                AdLogUtil.Log().e("video", "AdmobVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception));
            }
        } else {
            AdLogUtil.Log().w("video", "AdmobVideo --> The rewarded ad wasn't ready yet.");
        }
    }
}

