/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdmobVideo
extends BaseVideo {
    private RewardedAd p;
    private RewardedAdLoadCallback q;

    public AdmobVideo(Context context, Network network) {
        super(context, network);
    }

    public boolean isLoaded() {
        return this.p != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.p != null) {
            this.p = null;
        }
        AdLogUtil.Log().d("video", "AdmobVideo --> destroy" + this.getLogString());
        if (this.q != null) {
            this.q = null;
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void initVideo() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.q = new RewardedAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    AdmobVideo.this.p = null;
                    AdLogUtil.Log().w("video", "AdmobVideo --> ad load failed, error :" + loadAdError.toString() + AdmobVideo.this.getLogString());
                    AdmobVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void a(@NonNull RewardedAd rewardedAd) {
                    AdmobVideo.this.p = rewardedAd;
                    AdLogUtil.Log().d("video", "AdmobVideo --> Video Ad was loaded." + AdmobVideo.this.getLogString());
                    AdmobVideo.this.adLoaded();
                }

                public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                    this.a((RewardedAd)object);
                }
            };
        }
    }

    protected void onVideoStartLoad() {
        if (null != this.q && null != this.mContext && null != this.mContext.get()) {
            try {
                RewardedAd.load((Context)((Context)this.mContext.get()).getApplicationContext(), (String)this.mNetwork.codeSeatId, (AdRequest)PlatformUtil.g(), (RewardedAdLoadCallback)this.q);
            }
            catch (Exception exception) {
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                exception.printStackTrace();
                AdLogUtil.Log().e("video", "AdmobVideo --> RewardedAd.load exception " + Log.getStackTraceString((Throwable)exception) + this.getLogString());
            }
        }
    }

    protected void onVideoShow() {
        if (null == this.mContext || null == this.mContext.get()) {
            AdLogUtil.Log().w("video", "AdmobVideo --> onVideoShow null == mContext.get() || null == mContext" + this.getLogString());
            return;
        }
        if (this.p != null) {
            try {
                this.p.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("video", "AdmobVideo --> Ad was shown." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.adImpression();
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().w("video", "AdmobVideo --> Ad failed to show." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.p = null;
                        if (null != adError) {
                            AdmobVideo.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobVideo.this.p = null;
                        AdLogUtil.Log().d("video", "AdmobVideo --> video is adClosed");
                        AdmobVideo.this.adClosed();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobVideo.this.adClicked();
                    }
                });
                if (this.mContext.get() instanceof Activity) {
                    Activity activity = (Activity)this.mContext.get();
                    AdLogUtil.Log().d("video", " activity is finish =" + activity.isFinishing());
                    this.p.show(activity, new OnUserEarnedRewardListener(){

                        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                            if (rewardItem == null) {
                                return;
                            }
                            AdLogUtil.Log().d("video", "AdmobVideo --> The user earned the reward." + AdmobVideo.this.getLogString());
                            int n = rewardItem.getAmount();
                            String string = rewardItem.getType();
                            AdmobVideo.this.onReward();
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                AdLogUtil.Log().e("video", "AdmobVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception) + this.getLogString());
            }
        } else {
            AdLogUtil.Log().w("video", "AdmobVideo --> The rewarded ad wasn't ready yet." + this.getLogString());
        }
    }
}

