/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobSplash
extends BaseSplash {
    private static final String TAG = "AdmobSplash";
    private static String AD_UNIT_ID = "";
    public AppOpenAd appOpenAd = null;
    private static boolean isShowingAd = false;
    public AppOpenAd.AppOpenAdLoadCallback loadCallback;
    private Activity currentActivity;

    public AdmobSplash(Context context, Network network) {
        super(context, network);
    }

    public void fetchAd() {
        if (this.isAdAvailable()) {
            return;
        }
        this.loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void a(AppOpenAd appOpenAd) {
                if (appOpenAd == null) {
                    return;
                }
                AdmobSplash.this.appOpenAd = appOpenAd;
                AdmobSplash.this.adLoaded();
                AdLogUtil.Log().d(AdmobSplash.TAG, "admob appOpenAd onAdLoaded" + AdmobSplash.this.getLogString());
                AdmobSplash.this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        AdmobSplash.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview show fail:" + adError.getMessage() + AdmobSplash.this.getLogString());
                    }

                    public void onAdShowedFullScreenContent() {
                        super.onAdShowedFullScreenContent();
                        AdmobSplash.this.adImpression();
                        isShowingAd = true;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdShow" + AdmobSplash.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        AdmobSplash.this.onSkipClick();
                        AdmobSplash.this.appOpenAd = null;
                        isShowingAd = false;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdClicked" + AdmobSplash.this.getLogString());
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobSplash.this.adClicked();
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                if (null != loadAdError) {
                    AdmobSplash.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                    AdLogUtil.Log().w(AdmobSplash.TAG, "admob splashview onError:" + loadAdError.toString() + AdmobSplash.this.getLogString());
                }
            }

            public /* synthetic */ void onAdLoaded(Object object) {
                this.a((AppOpenAd)object);
            }
        };
        if (!TextUtils.isEmpty((CharSequence)this.mNetwork.codeSeatId)) {
            try {
                AppOpenAd.load((Context)CoreUtil.getContext(), (String)this.mNetwork.codeSeatId, (AdRequest)PlatformUtil.g(), (int)this.getOrientation(), (AppOpenAd.AppOpenAdLoadCallback)this.loadCallback);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            try {
                this.appOpenAd.show(this.currentActivity);
            }
            catch (Exception exception) {
                this.onTimeReach();
            }
        } else {
            this.onTimeReach();
        }
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null;
    }

    protected void onSplashStartLoad() {
    }

    protected View getSplash() {
        final long l = System.currentTimeMillis();
        ExistsCheck.a(CoreUtil.getContext(), new OnInitializationCompleteListener(){

            public void onInitializationComplete(@NonNull InitializationStatus initializationStatus) {
                AdLogUtil.Log().d(AdmobSplash.TAG, "onInitializationComplete " + (System.currentTimeMillis() - l));
                AdmobSplash.this.fetchAd();
            }
        });
        if (CoreUtil.getContext() != null) {
            return new View(CoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    protected void onSplashShow() {
        this.showAdIfAvailable();
    }

    protected boolean supportTimer() {
        return false;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.appOpenAd != null) {
            this.appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
        }
        if (this.loadCallback != null) {
            this.loadCallback = null;
        }
        AdLogUtil.Log().d(TAG, "destroy " + this.getLogString());
    }
}

