/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdmobBanner
extends BaseBanner<AdView> {
    private AdView a;
    private int b;

    public AdmobBanner(Context context, Network network, int n) {
        super(context, network);
        this.b = n;
        AdLogUtil.Log().d("AdmobBanner", "bannerSize:=" + n + this.getLogString());
    }

    private AdSize a() {
        AdSize adSize = AdSize.BANNER;
        if (this.mContext == null || this.mContext.get() == null) {
            return adSize;
        }
        Context context = (Context)this.mContext.get();
        if (context != null && context instanceof Activity) {
            Display display;
            WindowManager windowManager = ((Activity)context).getWindowManager();
            Display display2 = display = windowManager != null ? windowManager.getDefaultDisplay() : null;
            if (display == null) {
                return adSize;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            float f = displayMetrics.widthPixels;
            float f2 = displayMetrics.density;
            if (f <= 0.0f || f2 <= 0.0f) {
                return adSize;
            }
            int n = (int)(f / f2);
            adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)n);
        }
        return adSize != null ? adSize : AdSize.BANNER;
    }

    protected AdView b() {
        if (this.mContext == null || this.mContext.get() == null) {
            return this.a;
        }
        Context context = (Context)this.mContext.get();
        if (this.a == null && context != null && this.mNetwork != null) {
            this.a = new AdView(context.getApplicationContext());
            this.a.setAdUnitId(this.mNetwork.getCodeSeatId());
            switch (this.b) {
                case 0: {
                    this.a.setAdSize(this.a());
                    break;
                }
                case 1: 
                case 3: {
                    this.a.setAdSize(AdSize.LARGE_BANNER);
                    break;
                }
                case 2: {
                    this.a.setAdSize(AdSize.MEDIUM_RECTANGLE);
                    break;
                }
                default: {
                    this.a.setAdSize(AdSize.BANNER);
                }
            }
            this.a.setAdListener(new AdListener(){

                public void onAdClosed() {
                    AdmobBanner.this.adClosed();
                }

                public void onAdFailedToLoad(LoadAdError loadAdError) {
                    AdLogUtil.Log().w("AdmobBanner", "banner onAdFailedToLoad:" + loadAdError.toString() + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdmobBanner", "banner onAdLoaded" + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdClicked");
                    super.onAdClicked();
                    AdmobBanner.this.adClicked();
                }

                public void onAdImpression() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdImpression");
                    super.onAdImpression();
                    AdmobBanner.this.adImpression();
                }
            });
        }
        return this.a;
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void onBannerLoad() {
        if (this.mContext == null || this.mContext.get() == null) {
            return;
        }
        Context context = (Context)this.mContext.get();
        if (context != null) {
            final long l = System.currentTimeMillis();
            ExistsCheck.a(context, new OnInitializationCompleteListener(){

                public void onInitializationComplete(@NonNull InitializationStatus initializationStatus) {
                    AdLogUtil.Log().d("AdmobBanner", "onInitializationComplete " + (System.currentTimeMillis() - l));
                    try {
                        if (AdmobBanner.this.a != null) {
                            AdmobBanner.this.a.loadAd(PlatformUtil.f());
                        } else {
                            AdLogUtil.Log().e("AdmobBanner", "onBannerLoad adView is null");
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }
    }

    protected void showBanner() {
        if (this.a != null) {
            this.a.setVisibility(0);
        }
    }

    protected void onBannerDestroy() {
        if (this.a != null) {
            this.a.setAdListener(null);
            this.a.destroy();
            this.a = null;
        }
        AdLogUtil.Log().d("AdmobBanner", "banner destroy" + this.getLogString());
    }

    protected /* synthetic */ View getBanner() {
        return this.b();
    }
}

