/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.holder;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.hisavana.admoblibrary.R;
import com.hisavana.common.base.BaseNativeViewHolder;
import com.hisavana.common.bean.AdSourceConfig;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NativeAdViewHolder
extends BaseNativeViewHolder {
    private NativeAdView v;
    private final LinkedHashMap<String, NativeAdView> w = new LinkedHashMap();

    public View getContainer(TAdNativeInfo tAdNativeInfo, ViewGroup viewGroup) {
        this.v = this.w.get(tAdNativeInfo.getAdId());
        if (this.v == null) {
            this.v = (NativeAdView)LayoutInflater.from((Context)viewGroup.getContext().getApplicationContext()).inflate(R.layout.google_native_app_unified_ad_view, viewGroup, false);
        } else {
            this.v.setTag(R.id.native_view_source, (Object)1);
        }
        return this.v;
    }

    public void destroy() {
        super.destroy();
        if (this.w.size() > 0) {
            Iterator<Map.Entry<String, NativeAdView>> iterator = this.w.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Map.Entry<String, NativeAdView> entry = iterator.next();
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().removeAllViews();
                entry.getValue().destroy();
            }
        }
        this.w.clear();
        if (this.v != null) {
            this.v.removeAllViews();
            this.v.destroy();
            this.v = null;
        }
    }

    public void addContentView(View view) {
        if (this.v != null && !this.isCachedAdView()) {
            AdLogUtil.Log().w("NativeAdViewHolder", "----> admob,addContentView container:" + this.v);
            this.v.removeAllViews();
            this.v.addView(view, 0);
        }
    }

    public void setBodyView(View view) {
        if (this.v != null) {
            this.v.setBodyView(view);
        }
    }

    public void setCallToActionView(View view) {
        if (this.v != null) {
            this.v.setCallToActionView(view);
        }
    }

    public void setCallToActionOtherView(View view) {
        super.setCallToActionOtherView(view);
        if (this.v != null) {
            this.v.setCallToActionView(view);
        }
    }

    public void setHeadlineView(View view) {
        if (this.v != null) {
            this.v.setHeadlineView(view);
        }
    }

    public void setMediaView(View view) {
        if (this.v != null) {
            if (view instanceof MediaView) {
                this.v.setMediaView((MediaView)view);
            } else {
                this.v.setImageView(view);
            }
        }
    }

    public void setNativeAd(TAdNativeInfo tAdNativeInfo) {
        if (this.w.containsValue(this.v)) {
            AdLogUtil.Log().w("NativeAdViewHolder", "----> admob container has called setNativeAd() before.");
            return;
        }
        try {
            if (tAdNativeInfo == null) {
                return;
            }
            Object object = tAdNativeInfo.getNativeAdWrapper().getNativeAd();
            if (this.v != null && object instanceof NativeAd) {
                if (this.v.getMediaView() != null) {
                    this.v.getMediaView().setMediaContent(((NativeAd)object).getMediaContent());
                }
                this.v.setNativeAd((NativeAd)object);
                this.a(tAdNativeInfo.getAdId(), this.v);
                AdLogUtil.Log().w("NativeAdViewHolder", "----> call setNativeAd()");
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    private void a(String string, NativeAdView nativeAdView) {
        try {
            this.w.put(string, nativeAdView);
            if (this.w.size() > 5) {
                AdLogUtil.Log().w("NativeAdViewHolder", "admob container holders exceed the max threshold");
                Map.Entry<String, NativeAdView> entry = this.w.entrySet().iterator().next();
                if (entry != null) {
                    this.w.remove(entry.getKey());
                }
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    public void setIconView(View view) {
        if (this.v != null) {
            this.v.setIconView(view);
        }
    }

    protected View createMediaView(Context context, TAdNativeInfo tAdNativeInfo) {
        List list;
        if (!(AdSourceConfig.isUseMediaView || (list = tAdNativeInfo.getImageList()) == null || list.isEmpty() || ((TAdNativeInfo.Image)list.get(0)).getDrawable() == null && TextUtils.isEmpty((CharSequence)((TAdNativeInfo.Image)list.get(0)).getUrl()))) {
            return new ImageView(context);
        }
        return new MediaView(context);
    }

    public View getIconView(Context context) {
        this.iconView = this.createIconView(context.getApplicationContext());
        return this.iconView;
    }

    public View getMediaView(Context context, TAdNativeInfo tAdNativeInfo) {
        this.mediaView = this.createMediaView(context.getApplicationContext(), tAdNativeInfo);
        return this.mediaView;
    }

    public boolean isCachedAdView() {
        return this.v != null && this.v.getTag(R.id.native_view_source) != null && (Integer)this.v.getTag(R.id.native_view_source) == 1;
    }
}

