/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobVideo
extends BaseVideo {
    private RewardedAd t;
    private RewardedAdLoadCallback u;

    public AdmobVideo(Context context, Network network) {
        super(context, network);
    }

    public boolean isLoaded() {
        return this.t != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.t != null) {
            this.t = null;
        }
        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> destroy" + this.getLogString());
        if (this.u != null) {
            this.u = null;
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void initVideo() {
        this.u = new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                AdmobVideo.this.t = null;
                AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> ad load failed, error :" + loadAdError.toString() + AdmobVideo.this.getLogString());
                AdmobVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
            }

            public void a(@NonNull RewardedAd rewardedAd) {
                AdmobVideo.this.t = rewardedAd;
                AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> Video Ad was loaded." + AdmobVideo.this.getLogString());
                AdmobVideo.this.adLoaded();
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((RewardedAd)object);
            }
        };
    }

    protected void onVideoStartLoad() {
        if (!ExistsCheck.b()) {
            this.adFailedToLoad(TAdErrorCode.ADMOB_AD_NOT_INIT_CODE_ERROR);
            return;
        }
        try {
            if (this.mNetwork == null || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId()) || this.u == null) {
                this.adFailedToLoad(new TAdErrorCode(1, "rewardedAdLoadCallback or codeSeatId is null"));
                return;
            }
            RewardedAd.load((Context)CoreUtil.getContext(), (String)this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.i(), (RewardedAdLoadCallback)this.u);
        }
        catch (Exception exception) {
            this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
            exception.printStackTrace();
            AdLogUtil.Log().e("AdmobVideo", "AdmobVideo --> RewardedAd.load exception " + Log.getStackTraceString((Throwable)exception) + this.getLogString());
        }
    }

    protected void onVideoShow() {
        if (null == this.mContext || null == this.mContext.get()) {
            AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> onVideoShow null == mContext.get() || null == mContext" + this.getLogString());
            return;
        }
        Context context = (Context)this.mContext.get();
        if (this.t != null && context != null) {
            try {
                this.t.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> Ad was shown." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.adImpression();
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> Ad failed to show." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.t = null;
                        if (null != adError) {
                            AdmobVideo.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobVideo.this.t = null;
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> video is adClosed");
                        AdmobVideo.this.adClosed();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobVideo.this.adClicked();
                    }
                });
                if (context instanceof Activity) {
                    Activity activity = (Activity)context;
                    AdLogUtil.Log().d("AdmobVideo", " activity is finish =" + activity.isFinishing());
                    this.t.show(activity, new OnUserEarnedRewardListener(){

                        public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                            AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> The user earned the reward." + AdmobVideo.this.getLogString());
                            AdmobVideo.this.onReward();
                        }
                    });
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                AdLogUtil.Log().e("AdmobVideo", "AdmobVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception) + this.getLogString());
            }
        } else {
            AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> The rewarded ad wasn't ready yet." + this.getLogString());
        }
    }
}

