/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdmobBanner
extends BaseBanner<AdView> {
    private AdView d;
    private int e;

    public AdmobBanner(Context context, Network network, int n) {
        super(context, network);
        this.e = n;
        AdLogUtil.Log().d("AdmobBanner", "bannerSize:=" + n + this.getLogString());
    }

    private AdSize c() {
        AdSize adSize = AdSize.BANNER;
        if (this.mContext == null || this.mContext.get() == null) {
            return adSize;
        }
        Context context = (Context)this.mContext.get();
        if (context != null && context instanceof Activity) {
            Display display;
            WindowManager windowManager = ((Activity)context).getWindowManager();
            Display display2 = display = windowManager != null ? windowManager.getDefaultDisplay() : null;
            if (display == null) {
                return adSize;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            float f = displayMetrics.widthPixels;
            float f2 = displayMetrics.density;
            if (f <= 0.0f || f2 <= 0.0f) {
                return adSize;
            }
            int n = (int)(f / f2);
            adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)n);
        }
        return adSize != null ? adSize : AdSize.BANNER;
    }

    protected AdView d() {
        if (this.mContext == null || this.mContext.get() == null) {
            return this.d;
        }
        Context context = (Context)this.mContext.get();
        if (this.d == null && context != null && this.mNetwork != null) {
            this.d = new AdView(context.getApplicationContext());
            this.d.setAdUnitId(this.mNetwork.getCodeSeatId());
            switch (this.e) {
                case 0: {
                    this.d.setAdSize(this.c());
                    break;
                }
                case 1: 
                case 3: {
                    this.d.setAdSize(AdSize.LARGE_BANNER);
                    break;
                }
                case 2: {
                    this.d.setAdSize(AdSize.MEDIUM_RECTANGLE);
                    break;
                }
                default: {
                    this.d.setAdSize(AdSize.BANNER);
                }
            }
            this.d.setAdListener(new AdListener(){

                public void onAdClosed() {
                    AdmobBanner.this.adClosed();
                }

                public void onAdFailedToLoad(LoadAdError loadAdError) {
                    AdLogUtil.Log().w("AdmobBanner", "banner onAdFailedToLoad:" + loadAdError.toString() + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdmobBanner", "banner onAdLoaded" + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdClicked");
                    super.onAdClicked();
                    AdmobBanner.this.adClicked();
                }

                public void onAdImpression() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdImpression");
                    super.onAdImpression();
                    AdmobBanner.this.adImpression();
                }
            });
        }
        return this.d;
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void onBannerLoad() {
        block7: {
            if (this.mContext == null || this.mContext.get() == null) {
                return;
            }
            Context context = (Context)this.mContext.get();
            if (context != null) {
                if (ExistsCheck.b()) {
                    try {
                        if (this.d != null) {
                            this.d.loadAd(PlatformUtil.i());
                            break block7;
                        }
                        AdLogUtil.Log().e("AdmobBanner", "onBannerLoad adView is null");
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                } else {
                    this.adFailedToLoad(TAdErrorCode.ADMOB_AD_NOT_INIT_CODE_ERROR);
                    AdLogUtil.Log().e("AdmobBanner", "onBannerLoad admob is not init");
                }
            }
        }
    }

    protected void showBanner() {
        if (this.d != null) {
            this.d.setVisibility(0);
        }
    }

    protected void onBannerDestroy() {
        if (this.d != null) {
            this.d.setAdListener(null);
            this.d.destroy();
            this.d = null;
        }
        AdLogUtil.Log().d("AdmobBanner", "banner destroy" + this.getLogString());
    }

    protected /* synthetic */ View getBanner() {
        return this.d();
    }
}

