/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobInterstitia
extends BaseInterstitial {
    private InterstitialAd g;
    private InterstitialAdLoadCallback h;

    public AdmobInterstitia(Context context, Network network) {
        super(context, network);
    }

    protected void onInterstitialStartLoad() {
        try {
            if (ExistsCheck.b()) {
                if (this.mNetwork == null || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId()) || this.h == null) {
                    this.adFailedToLoad(new TAdErrorCode(1, "onInterstitialStartLoad loadCallback or codeSeatId is null"));
                    AdLogUtil.Log().e("AdmobInterstitia", "onInterstitialStartLoad loadCallback or codeSeatId is null");
                    return;
                }
                InterstitialAd.load((Context)CoreUtil.getContext(), (String)this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.i(), (InterstitialAdLoadCallback)this.h);
            } else {
                this.adFailedToLoad(TAdErrorCode.ADMOB_AD_NOT_INIT_CODE_ERROR);
                AdLogUtil.Log().e("AdmobInterstitia", "onInterstitialStartLoad admob is not init");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void initInterstitial() {
        this.h = new InterstitialAdLoadCallback(){

            public void a(@NonNull InterstitialAd interstitialAd) {
                super.onAdLoaded((Object)interstitialAd);
                AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is Loaded" + AdmobInterstitia.this.getLogString());
                AdmobInterstitia.this.g = interstitialAd;
                AdmobInterstitia.this.adLoaded();
                AdmobInterstitia.this.g.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        AdmobInterstitia.this.g = null;
                        if (adError != null) {
                            AdmobInterstitia.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdShowedFullScreenContent() {
                        super.onAdShowedFullScreenContent();
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is onAdShowedFullScreenContent" + AdmobInterstitia.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        AdmobInterstitia.this.g = null;
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is adClosed" + AdmobInterstitia.this.getLogString());
                        AdmobInterstitia.this.adClosed();
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is onAdImpression" + AdmobInterstitia.this.getLogString());
                        AdmobInterstitia.this.adImpression();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobInterstitia.this.adClicked();
                    }
                });
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                AdmobInterstitia.this.g = null;
                if (null != loadAdError) {
                    AdLogUtil.Log().w("AdmobInterstitia", "ad load failed, error :" + loadAdError.toString() + AdmobInterstitia.this.getLogString());
                    AdmobInterstitia.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((InterstitialAd)object);
            }
        };
    }

    protected void onInterstitialShow(Activity activity) {
        if (this.g != null && activity != null) {
            this.g.show(activity);
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    public boolean isLoaded() {
        return this.g != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.g != null) {
            this.g = null;
        }
        AdLogUtil.Log().d("AdmobInterstitia", "destroy" + this.getLogString());
        if (this.h != null) {
            this.h = null;
        }
    }
}

