/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseBanner;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;

public class AdmobBanner
extends BaseBanner<AdView> {
    private AdView b;
    private int c;

    public AdmobBanner(Context context, Network network, int n) {
        super(context, network);
        this.c = n;
        AdLogUtil.Log().d("AdmobBanner", "bannerSize:=" + n + this.getLogString());
    }

    private AdSize a() {
        AdSize adSize = AdSize.BANNER;
        if (this.mContext == null || this.mContext.get() == null) {
            return adSize;
        }
        Context context = (Context)this.mContext.get();
        if (context != null && context instanceof Activity) {
            Display display;
            WindowManager windowManager = ((Activity)context).getWindowManager();
            Display display2 = display = windowManager != null ? windowManager.getDefaultDisplay() : null;
            if (display == null) {
                return adSize;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            float f = displayMetrics.widthPixels;
            float f2 = displayMetrics.density;
            if (f <= 0.0f || f2 <= 0.0f) {
                return adSize;
            }
            int n = (int)(f / f2);
            adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)n);
        }
        return adSize != null ? adSize : AdSize.BANNER;
    }

    protected AdView b() {
        if (this.mContext == null || this.mContext.get() == null) {
            return this.b;
        }
        Context context = (Context)this.mContext.get();
        if (this.b == null && context != null && this.mNetwork != null) {
            this.b = new AdView(context.getApplicationContext());
            this.b.setAdUnitId(this.mNetwork.getCodeSeatId());
            switch (this.c) {
                case 0: {
                    this.b.setAdSize(this.a());
                    break;
                }
                case 1: 
                case 3: {
                    this.b.setAdSize(AdSize.LARGE_BANNER);
                    break;
                }
                case 2: {
                    this.b.setAdSize(AdSize.MEDIUM_RECTANGLE);
                    break;
                }
                default: {
                    this.b.setAdSize(AdSize.BANNER);
                }
            }
            this.b.setAdListener(new AdListener(){

                public void onAdClosed() {
                    AdmobBanner.this.adClosed();
                }

                public void onAdFailedToLoad(LoadAdError loadAdError) {
                    AdLogUtil.Log().w("AdmobBanner", "banner onAdFailedToLoad:" + loadAdError.toString() + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdmobBanner", "banner onAdLoaded" + AdmobBanner.this.getLogString());
                    AdmobBanner.this.adLoaded();
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdClicked");
                    super.onAdClicked();
                    AdmobBanner.this.adClicked();
                }

                public void onAdImpression() {
                    AdLogUtil.Log().d("AdmobBanner", "onAdImpression");
                    super.onAdImpression();
                    AdmobBanner.this.adImpression();
                }
            });
        }
        return this.b;
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void onBannerLoad() {
        if (this.mContext == null || this.mContext.get() == null) {
            return;
        }
        Context context = (Context)this.mContext.get();
        if (context != null) {
            try {
                if (this.b != null) {
                    this.b.loadAd(PlatformUtil.g());
                } else {
                    AdLogUtil.Log().e("AdmobBanner", "onBannerLoad adView is null");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void showBanner() {
        if (this.b != null) {
            this.b.setVisibility(0);
        }
    }

    protected void onBannerDestroy() {
        if (this.b != null) {
            this.b.setAdListener(null);
            this.b.destroy();
            this.b = null;
        }
        AdLogUtil.Log().d("AdmobBanner", "banner destroy" + this.getLogString());
    }

    protected /* synthetic */ View getBanner() {
        return this.b();
    }
}

