/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.holder;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.hisavana.admoblibrary.R;
import com.hisavana.common.base.BaseNativeViewHolder;
import com.hisavana.common.bean.AdSourceConfig;
import com.hisavana.common.bean.TAdNativeInfo;
import com.hisavana.common.utils.AdLogUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NativeAdViewHolder
extends BaseNativeViewHolder {
    private NativeAdView u;
    private final LinkedHashMap<String, NativeAdView> v = new LinkedHashMap();

    public View getContainer(TAdNativeInfo tAdNativeInfo, ViewGroup viewGroup) {
        if (viewGroup == null || viewGroup.getContext() == null) {
            return null;
        }
        this.u = this.v.get(tAdNativeInfo.getAdId());
        if (this.u == null) {
            this.u = (NativeAdView)LayoutInflater.from((Context)viewGroup.getContext().getApplicationContext()).inflate(R.layout.google_native_app_unified_ad_view, viewGroup, false);
        } else {
            this.u.setTag(R.id.native_view_source, (Object)1);
        }
        return this.u;
    }

    public void destroy() {
        super.destroy();
        if (this.v.size() > 0) {
            Iterator<Map.Entry<String, NativeAdView>> iterator = this.v.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Map.Entry<String, NativeAdView> entry = iterator.next();
                if (entry == null || entry.getValue() == null) continue;
                entry.getValue().removeAllViews();
                entry.getValue().destroy();
            }
        }
        this.v.clear();
        if (this.u != null) {
            this.u.removeAllViews();
            this.u.destroy();
            this.u = null;
        }
    }

    public void addContentView(View view) {
        if (this.u != null && !this.isCachedAdView()) {
            AdLogUtil.Log().w("NativeAdViewHolder", "----> admob,addContentView container:" + this.u);
            this.u.removeAllViews();
            this.u.addView(view, 0);
        }
    }

    public void setBodyView(View view) {
        if (this.u != null) {
            this.u.setBodyView(view);
        }
    }

    public void setCallToActionView(View view) {
        if (this.u != null) {
            this.u.setCallToActionView(view);
        }
    }

    public void setCallToActionOtherView(View view) {
        super.setCallToActionOtherView(view);
        if (this.u != null) {
            this.u.setCallToActionView(view);
        }
    }

    public void setHeadlineView(View view) {
        if (this.u != null) {
            this.u.setHeadlineView(view);
        }
    }

    public void setMediaView(View view) {
        if (this.u != null) {
            if (view instanceof MediaView) {
                this.u.setMediaView((MediaView)view);
            } else {
                this.u.setImageView(view);
            }
        }
    }

    public void setNativeAd(TAdNativeInfo tAdNativeInfo) {
        if (this.v.containsValue(this.u)) {
            AdLogUtil.Log().w("NativeAdViewHolder", "----> admob container has called setNativeAd() before.");
            return;
        }
        try {
            if (tAdNativeInfo == null) {
                return;
            }
            Object object = tAdNativeInfo.getNativeAdWrapper().getNativeAd();
            if (this.u != null && object instanceof NativeAd) {
                if (this.u.getMediaView() != null) {
                    this.u.getMediaView().setMediaContent(((NativeAd)object).getMediaContent());
                }
                this.u.setNativeAd((NativeAd)object);
                this.a(tAdNativeInfo.getAdId(), this.u);
                AdLogUtil.Log().w("NativeAdViewHolder", "----> call setNativeAd()");
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    private void a(String string, NativeAdView nativeAdView) {
        try {
            this.v.put(string, nativeAdView);
            if (this.v.size() > 5) {
                AdLogUtil.Log().w("NativeAdViewHolder", "admob container holders exceed the max threshold");
                Map.Entry<String, NativeAdView> entry = this.v.entrySet().iterator().next();
                if (entry != null) {
                    this.v.remove(entry.getKey());
                }
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("NativeAdViewHolder", Log.getStackTraceString((Throwable)exception));
        }
    }

    public void setIconView(View view) {
        if (this.u != null) {
            this.u.setIconView(view);
        }
    }

    protected View createMediaView(Context context, TAdNativeInfo tAdNativeInfo) {
        List list;
        if (!(AdSourceConfig.isUseMediaView || (list = tAdNativeInfo.getImageList()) == null || list.isEmpty() || ((TAdNativeInfo.Image)list.get(0)).getDrawable() == null && TextUtils.isEmpty((CharSequence)((TAdNativeInfo.Image)list.get(0)).getUrl()))) {
            return new ImageView(context);
        }
        return new MediaView(context);
    }

    public View getIconView(Context context) {
        this.iconView = this.createIconView(context.getApplicationContext());
        return this.iconView;
    }

    public View getMediaView(Context context, TAdNativeInfo tAdNativeInfo) {
        this.mediaView = this.createMediaView(context.getApplicationContext(), tAdNativeInfo);
        return this.mediaView;
    }

    public boolean isCachedAdView() {
        return this.u != null && this.u.getTag(R.id.native_view_source) != null && (Integer)this.u.getTag(R.id.native_view_source) == 1;
    }
}

