/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobSplash
extends BaseSplash {
    private static final String TAG = "AdmobSplash";
    private static String AD_UNIT_ID = "";
    private static boolean isShowingAd = false;
    public AppOpenAd appOpenAd = null;
    public AppOpenAd.AppOpenAdLoadCallback loadCallback;
    private Activity currentActivity;

    public AdmobSplash(Context context, Network network) {
        super(context, network);
    }

    public void fetchAd() {
        AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadCallback;
        if (object.isAdAvailable()) {
            return;
        }
        AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadCallback2 = appOpenAdLoadCallback;
        appOpenAdLoadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void a(AppOpenAd appOpenAd) {
                if (appOpenAd == null) {
                    return;
                }
                1 v0 = this;
                v0.AdmobSplash.this.appOpenAd = appOpenAd;
                v0.AdmobSplash.this.adLoaded();
                AdLogUtil.Log().d(AdmobSplash.TAG, "admob appOpenAd onAdLoaded" + AdmobSplash.this.getLogString());
                v0.AdmobSplash.this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        if (adError != null) {
                            AdError adError2 = adError;
                            int n = adError2.getCode();
                            AdmobSplash.this.adFailedToLoad(new TAdErrorCode(n, adError2.getMessage()));
                            AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview show fail:" + adError.getMessage() + AdmobSplash.this.getLogString());
                        }
                    }

                    public void onAdShowedFullScreenContent() {
                        1 v0 = this;
                        super.onAdShowedFullScreenContent();
                        v0.AdmobSplash.this.adImpression();
                        isShowingAd = true;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdShow" + AdmobSplash.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        1 v0 = this;
                        super.onAdDismissedFullScreenContent();
                        v0.AdmobSplash.this.onSkipClick();
                        v0.AdmobSplash.this.appOpenAd = null;
                        isShowingAd = false;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdClicked" + AdmobSplash.this.getLogString());
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                    }

                    public void onAdClicked() {
                        1 v0 = this;
                        super.onAdClicked();
                        v0.AdmobSplash.this.adClicked();
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                if (loadAdError != null) {
                    LoadAdError loadAdError2 = loadAdError;
                    int n = loadAdError2.getCode();
                    AdmobSplash.this.adFailedToLoad(new TAdErrorCode(n, loadAdError2.getMessage()));
                    AdLogUtil.Log().w(AdmobSplash.TAG, "admob splashview onError:" + loadAdError.toString() + AdmobSplash.this.getLogString());
                }
            }
        };
        object.loadCallback = appOpenAdLoadCallback2;
        appOpenAdLoadCallback2 = object.mNetwork;
        if (appOpenAdLoadCallback2 != null && !TextUtils.isEmpty((CharSequence)appOpenAdLoadCallback2.getCodeSeatId())) {
            Context context = CoreUtil.getContext();
            AdmobSplash admobSplash = object;
            AdmobSplash admobSplash2 = admobSplash;
            AdmobSplash admobSplash3 = admobSplash;
            Object object = admobSplash.mNetwork.getCodeSeatId();
            appOpenAdLoadCallback2 = PlatformUtil.a();
            int n = admobSplash3.getOrientation();
            AppOpenAd.AppOpenAdLoadCallback appOpenAdLoadCallback3 = admobSplash2.loadCallback;
            try {
                AppOpenAd.load((Context)context, (String)object, (AdRequest)appOpenAdLoadCallback2, (int)n, (AppOpenAd.AppOpenAdLoadCallback)appOpenAdLoadCallback3);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            try {
                this.appOpenAd.show(this.currentActivity);
            }
            catch (Exception exception) {
                this.onTimeReach();
            }
        } else {
            this.onTimeReach();
        }
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null;
    }

    public void onSplashStartLoad() {
        this.fetchAd();
    }

    public View getSplash() {
        if (CoreUtil.getContext() != null) {
            return new View(CoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    public void onSplashShow() {
        this.showAdIfAvailable();
    }

    public boolean supportTimer() {
        return false;
    }

    public void destroyAd() {
        AdmobSplash admobSplash = this;
        super.destroyAd();
        AppOpenAd appOpenAd = admobSplash.appOpenAd;
        if (appOpenAd != null) {
            appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
        }
        if (this.loadCallback != null) {
            this.loadCallback = null;
        }
        AdLogUtil.Log().d(TAG, "destroy " + this.getLogString());
    }
}

