/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseVideo;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobVideo
extends BaseVideo {
    private RewardedAd p;
    private RewardedAdLoadCallback q;

    public AdmobVideo(Context context, Network network) {
        super(context, network);
    }

    public boolean isLoaded() {
        return this.p != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.p != null) {
            this.p = null;
        }
        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> destroy" + this.getLogString());
        if (this.q != null) {
            this.q = null;
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    protected void initVideo() {
        this.q = new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                AdmobVideo.this.p = null;
                AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> ad load failed, error :" + loadAdError.toString() + AdmobVideo.this.getLogString());
                AdmobVideo.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
            }

            public void a(@NonNull RewardedAd rewardedAd) {
                AdmobVideo.this.p = rewardedAd;
                AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> Video Ad was loaded." + AdmobVideo.this.getLogString());
                AdmobVideo.this.adLoaded();
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((RewardedAd)object);
            }
        };
    }

    protected void onVideoStartLoad() {
        final long l = System.currentTimeMillis();
        ExistsCheck.a(CoreUtil.getContext(), new OnInitializationCompleteListener(){

            public void onInitializationComplete(@NonNull InitializationStatus initializationStatus) {
                AdLogUtil.Log().d("AdmobVideo", "onInitializationComplete " + (System.currentTimeMillis() - l));
                try {
                    if (AdmobVideo.this.mNetwork == null || TextUtils.isEmpty((CharSequence)AdmobVideo.this.mNetwork.getCodeSeatId()) || AdmobVideo.this.q == null) {
                        AdmobVideo.this.adFailedToLoad(new TAdErrorCode(1, "rewardedAdLoadCallback or codeSeatId is null"));
                        return;
                    }
                    RewardedAd.load((Context)CoreUtil.getContext(), (String)AdmobVideo.this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.g(), (RewardedAdLoadCallback)AdmobVideo.this.q);
                }
                catch (Exception exception) {
                    AdmobVideo.this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                    exception.printStackTrace();
                    AdLogUtil.Log().e("AdmobVideo", "AdmobVideo --> RewardedAd.load exception " + Log.getStackTraceString((Throwable)exception) + AdmobVideo.this.getLogString());
                }
            }
        });
    }

    protected void onVideoShow(Activity activity) {
        if (null == activity) {
            AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> onVideoShow null == activity " + this.getLogString());
            return;
        }
        if (this.p != null) {
            try {
                this.p.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdShowedFullScreenContent() {
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> Ad was shown." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.adImpression();
                    }

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> Ad failed to show." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.p = null;
                        if (null != adError) {
                            AdmobVideo.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdDismissedFullScreenContent() {
                        AdmobVideo.this.p = null;
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> video is adClosed");
                        AdmobVideo.this.adClosed();
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobVideo.this.adClicked();
                    }
                });
                AdLogUtil.Log().d("AdmobVideo", " activity is finish =" + activity.isFinishing());
                this.p.show(activity, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        AdLogUtil.Log().d("AdmobVideo", "AdmobVideo --> The user earned the reward." + AdmobVideo.this.getLogString());
                        AdmobVideo.this.onReward();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.adFailedToLoad(new TAdErrorCode(1, exception.getMessage()));
                AdLogUtil.Log().e("AdmobVideo", "AdmobVideo --> onVideoShow \u5c55\u793a\u5f02\u5e38" + Log.getStackTraceString((Throwable)exception) + this.getLogString());
            }
        } else {
            AdLogUtil.Log().w("AdmobVideo", "AdmobVideo --> The rewarded ad wasn't ready yet." + this.getLogString());
        }
    }
}

