/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobInterstitia
extends BaseInterstitial {
    private InterstitialAd mInterstitialAd;
    private InterstitialAdLoadCallback d;

    public AdmobInterstitia(Context context, Network network) {
        super(context, network);
    }

    protected void onInterstitialStartLoad() {
        try {
            long l = System.currentTimeMillis();
            if (this.mNetwork == null || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId()) || this.d == null) {
                this.adFailedToLoad(new TAdErrorCode(1, "onInterstitialStartLoad loadCallback or codeSeatId is null"));
                AdLogUtil.Log().e("AdmobInterstitia", "onInterstitialStartLoad loadCallback or codeSeatId is null");
                return;
            }
            try {
                InterstitialAd.load((Context)CoreUtil.getContext(), (String)this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.g(), (InterstitialAdLoadCallback)this.d);
            }
            catch (Exception exception) {
                AdLogUtil.Log().e("AdmobInterstitia", "onInterstitialStartLoad " + Log.getStackTraceString((Throwable)exception));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void initInterstitial() {
        this.d = new InterstitialAdLoadCallback(){

            public void a(@NonNull InterstitialAd interstitialAd) {
                super.onAdLoaded((Object)interstitialAd);
                AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is Loaded" + AdmobInterstitia.this.getLogString());
                AdmobInterstitia.this.mInterstitialAd = interstitialAd;
                AdmobInterstitia.this.adLoaded();
                AdmobInterstitia.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        AdmobInterstitia.this.mInterstitialAd = null;
                        if (adError != null) {
                            AdmobInterstitia.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdShowedFullScreenContent() {
                        super.onAdShowedFullScreenContent();
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is onAdShowedFullScreenContent" + AdmobInterstitia.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        AdmobInterstitia.this.mInterstitialAd = null;
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is adClosed" + AdmobInterstitia.this.getLogString());
                        AdmobInterstitia.this.adClosed();
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is onAdImpression" + AdmobInterstitia.this.getLogString());
                        AdmobInterstitia.this.adImpression(null);
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobInterstitia.this.adClicked(null);
                    }
                });
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                AdmobInterstitia.this.mInterstitialAd = null;
                if (null != loadAdError) {
                    AdLogUtil.Log().w("AdmobInterstitia", "ad load failed, error :" + loadAdError.toString() + AdmobInterstitia.this.getLogString());
                    AdmobInterstitia.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((InterstitialAd)object);
            }
        };
    }

    protected void onInterstitialShow(Activity activity) {
        if (this.mInterstitialAd != null && activity != null) {
            this.mInterstitialAd.show(activity);
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    public boolean isLoaded() {
        return this.mInterstitialAd != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd = null;
        }
        AdLogUtil.Log().d("AdmobInterstitia", "destroy" + this.getLogString());
        if (this.d != null) {
            this.d = null;
        }
    }
}

