/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseInterstitial;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobInterstitia
extends BaseInterstitial {
    private InterstitialAd e;
    private InterstitialAdLoadCallback f;

    public AdmobInterstitia(Context context, Network network) {
        super(context, network);
        AdLogUtil.Log().d("AdmobInterstitia", "Admob Interstitial");
    }

    protected void onInterstitialStartLoad() {
        try {
            if (this.mNetwork == null || TextUtils.isEmpty((CharSequence)this.mNetwork.getCodeSeatId()) || this.f == null) {
                this.adFailedToLoad(new TAdErrorCode(30003, "onInterstitialStartLoad loadCallback or codeSeatId is null"));
                AdLogUtil.Log().e("AdmobInterstitia", "onInterstitialStartLoad loadCallback or codeSeatId is null");
                return;
            }
            InterstitialAd.load((Context)CoreUtil.getContext(), (String)this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.h(), (InterstitialAdLoadCallback)this.f);
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("AdmobInterstitia", "onInterstitialStartLoad " + Log.getStackTraceString((Throwable)exception));
        }
    }

    protected void initInterstitial() {
        this.f = new InterstitialAdLoadCallback(){

            public void a(@NonNull InterstitialAd interstitialAd) {
                super.onAdLoaded((Object)interstitialAd);
                AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is Loaded" + AdmobInterstitia.this.getLogString());
                AdmobInterstitia.this.e = interstitialAd;
                AdmobInterstitia.this.adLoaded();
                AdmobInterstitia.this.e.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        AdmobInterstitia.this.e = null;
                        if (adError != null) {
                            AdmobInterstitia.this.onAdShowError(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                        }
                    }

                    public void onAdShowedFullScreenContent() {
                        super.onAdShowedFullScreenContent();
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is onAdShowedFullScreenContent" + AdmobInterstitia.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        AdmobInterstitia.this.e = null;
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is adClosed" + AdmobInterstitia.this.getLogString());
                        AdmobInterstitia.this.adClosed();
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                        AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is onAdImpression" + AdmobInterstitia.this.getLogString());
                        AdmobInterstitia.this.adImpression(null);
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobInterstitia.this.adClicked(null);
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                AdmobInterstitia.this.e = null;
                if (null != loadAdError) {
                    AdLogUtil.Log().w("AdmobInterstitia", "ad load failed, error :" + loadAdError.toString() + AdmobInterstitia.this.getLogString());
                    AdmobInterstitia.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                }
            }

            public /* synthetic */ void onAdLoaded(@NonNull Object object) {
                this.a((InterstitialAd)object);
            }
        };
    }

    protected void onInterstitialShow(Activity activity) {
        if (this.e != null && activity != null) {
            this.e.setOnPaidEventListener(new OnPaidEventListener(){

                public void onPaidEvent(AdValue adValue) {
                    if (adValue == null) {
                        return;
                    }
                    long l = adValue.getValueMicros();
                    String string = adValue.getCurrencyCode();
                    int n = adValue.getPrecisionType();
                    AdLogUtil.Log().d("AdmobInterstitia", "onPaidEvent valueMicros " + l + ",currencyCode " + string + ",precisionType " + n);
                    AdmobInterstitia.this.admobShowPriceTracking(l, string, n);
                }
            });
            ExistsCheck.a();
            this.e.show(activity);
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            AdLogUtil.Log().e("AdmobInterstitia", "The ad wasn't ready or activity is null. " + this.getLogString());
        }
    }

    protected boolean supportTimer() {
        return false;
    }

    public boolean isLoaded() {
        return this.e != null;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.e != null) {
            this.e.setOnPaidEventListener(null);
            this.e = null;
        }
        AdLogUtil.Log().d("AdmobInterstitia", "destroy" + this.getLogString());
        if (this.f != null) {
            this.f = null;
        }
    }
}

