/*
 * Decompiled with CFR 0.152.
 */
package com.hisavana.admoblibrary.excuter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.hisavana.admoblibrary.check.ExistsCheck;
import com.hisavana.admoblibrary.util.PlatformUtil;
import com.hisavana.common.base.BaseSplash;
import com.hisavana.common.bean.Network;
import com.hisavana.common.bean.TAdErrorCode;
import com.hisavana.common.utils.AdLogUtil;
import com.transsion.core.CoreUtil;

public class AdmobSplash
extends BaseSplash {
    private static final String TAG = "AdmobSplash";
    private AppOpenAd appOpenAd = null;
    private static boolean isShowingAd = false;
    private AppOpenAd.AppOpenAdLoadCallback loadCallback;
    private Activity currentActivity;

    public AdmobSplash(Context context, Network network) {
        super(context, network);
    }

    public void fetchAd() {
        this.loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void a(AppOpenAd appOpenAd) {
                if (appOpenAd == null) {
                    return;
                }
                AdmobSplash.this.appOpenAd = appOpenAd;
                AdmobSplash.this.adLoaded();
                AdLogUtil.Log().d(AdmobSplash.TAG, "admob appOpenAd onAdLoaded" + AdmobSplash.this.getLogString());
                AdmobSplash.this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdFailedToShowFullScreenContent(AdError adError) {
                        super.onAdFailedToShowFullScreenContent(adError);
                        if (null != adError) {
                            AdmobSplash.this.adFailedToLoad(new TAdErrorCode(adError.getCode(), adError.getMessage()));
                            AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview show fail:" + adError.getMessage() + AdmobSplash.this.getLogString());
                        }
                    }

                    public void onAdShowedFullScreenContent() {
                        super.onAdShowedFullScreenContent();
                        AdmobSplash.this.adImpression(null);
                        isShowingAd = true;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdShow" + AdmobSplash.this.getLogString());
                    }

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        AdmobSplash.this.onSkipClick();
                        AdmobSplash.this.appOpenAd = null;
                        isShowingAd = false;
                        AdLogUtil.Log().d(AdmobSplash.TAG, "admob splashview onAdClicked" + AdmobSplash.this.getLogString());
                    }

                    public void onAdImpression() {
                        super.onAdImpression();
                        AdLogUtil.Log().d(AdmobSplash.TAG, "onAdImpression");
                    }

                    public void onAdClicked() {
                        super.onAdClicked();
                        AdmobSplash.this.adClicked(null);
                    }
                });
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                if (null != loadAdError) {
                    AdmobSplash.this.adFailedToLoad(new TAdErrorCode(loadAdError.getCode(), loadAdError.getMessage()));
                    AdLogUtil.Log().w(AdmobSplash.TAG, "admob splashview onError:" + loadAdError.toString() + AdmobSplash.this.getLogString());
                }
            }

            public /* synthetic */ void onAdLoaded(Object object) {
                this.a((AppOpenAd)object);
            }
        };
        try {
            ExistsCheck.a(CoreUtil.getContext(), new ExistsCheck.AdmobInitializationListener(){

                @Override
                public void c() {
                    if (AdmobSplash.this.isAdAvailable()) {
                        return;
                    }
                    if (null != AdmobSplash.this.mNetwork && !TextUtils.isEmpty((CharSequence)AdmobSplash.this.mNetwork.getCodeSeatId())) {
                        AppOpenAd.load((Context)CoreUtil.getContext(), (String)AdmobSplash.this.mNetwork.getCodeSeatId(), (AdRequest)PlatformUtil.k(), (int)AdmobSplash.this.getOrientation(), (AppOpenAd.AppOpenAdLoadCallback)AdmobSplash.this.loadCallback);
                    }
                }

                @Override
                public void d() {
                    AdmobSplash.this.adFailedToLoad(TAdErrorCode.ERROR_AD_SOURCE_INIT_FAILED);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.adFailedToLoad(new TAdErrorCode(30003, Log.getStackTraceString((Throwable)exception)));
        }
    }

    public void showAdIfAvailable() {
        if (!isShowingAd && this.isAdAvailable()) {
            try {
                this.appOpenAd.setOnPaidEventListener(new OnPaidEventListener(){

                    public void onPaidEvent(AdValue adValue) {
                        if (adValue == null) {
                            return;
                        }
                        long l = adValue.getValueMicros();
                        String string = adValue.getCurrencyCode();
                        int n = adValue.getPrecisionType();
                        AdLogUtil.Log().d(AdmobSplash.TAG, "onPaidEvent valueMicros " + l + ",currencyCode " + string + ",precisionType " + n);
                        AdmobSplash.this.admobShowPriceTracking(l, string, n);
                    }
                });
                this.appOpenAd.show(this.currentActivity);
            }
            catch (Exception exception) {
                this.onAdShowError(new TAdErrorCode(50001, exception.getMessage()));
                this.onTimeReach();
                AdLogUtil.Log().e(TAG, "showAdIfAvailable " + Log.getStackTraceString((Throwable)exception));
            }
        } else {
            this.onAdShowError(TAdErrorCode.ERROR_SHOW_EXCEPTION);
            this.onTimeReach();
            AdLogUtil.Log().e(TAG, "showAdIfAvailable,show error,ad is showing or ad is not available");
        }
    }

    public boolean isAdAvailable() {
        return this.appOpenAd != null;
    }

    protected void onSplashStartLoad() {
        this.fetchAd();
    }

    protected View getSplash() {
        if (CoreUtil.getContext() != null) {
            return new View(CoreUtil.getContext().getApplicationContext());
        }
        return null;
    }

    protected void onSplashShow() {
        this.showAdIfAvailable();
    }

    protected boolean supportTimer() {
        return false;
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.appOpenAd != null) {
            this.appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
        }
        if (this.loadCallback != null) {
            this.loadCallback = null;
        }
        AdLogUtil.Log().d(TAG, "destroy " + this.getLogString());
    }
}

